/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.broadcast.normal;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.test.client.consumer.broadcast.BaseBroadCastIT;
import org.apache.rocketmq.test.client.consumer.broadcast.normal.NormalMsgTwoSameGroupConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQBroadCastConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BroadCastNormalMsgRecvFailIT
extends BaseBroadCastIT {
    private static Logger logger = Logger.getLogger(NormalMsgTwoSameGroupConsumerIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.printSeperator();
        this.topic = BroadCastNormalMsgRecvFailIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = BroadCastNormalMsgRecvFailIT.getProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseBroadCastIT.shutdown();
    }

    @Test
    public void testStartTwoConsumerAndOneConsumerFail() {
        int msgSize = 16;
        RMQBroadCastConsumer consumer1 = BroadCastNormalMsgRecvFailIT.getBroadCastConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQBroadCastConsumer consumer2 = BroadCastNormalMsgRecvFailIT.getBroadCastConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener(ConsumeConcurrentlyStatus.RECONSUME_LATER));
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

