/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.broadcast.order;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.client.consumer.broadcast.BaseBroadCastIT;
import org.apache.rocketmq.test.client.rmq.RMQBroadCastConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.order.RMQOrderListener;
import org.apache.rocketmq.test.message.MessageQueueMsg;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OrderMsgBroadCastIT
extends BaseBroadCastIT {
    private static Logger logger = Logger.getLogger(OrderMsgBroadCastIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;
    private int broadcastConsumeTime = 60000;

    @Before
    public void setUp() {
        this.topic = OrderMsgBroadCastIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = OrderMsgBroadCastIT.getProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseBroadCastIT.shutdown();
    }

    @Test
    public void testTwoConsumerSubTag() {
        int msgSize = 10;
        RMQBroadCastConsumer consumer1 = OrderMsgBroadCastIT.getBroadCastConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQOrderListener());
        RMQBroadCastConsumer consumer2 = OrderMsgBroadCastIT.getBroadCastConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQOrderListener());
        TestUtils.waitForSeconds((long)waitTime);
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), this.broadcastConsumeTime);
        consumer2.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), this.broadcastConsumeTime);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer1.getListener()).getMsgs())).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer2.getListener()).getMsgs())).isEqualTo((Object)true);
    }
}

