/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.broadcast.tag;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.client.consumer.broadcast.BaseBroadCastIT;
import org.apache.rocketmq.test.client.consumer.broadcast.tag.BroadCastTwoConsumerSubTagIT;
import org.apache.rocketmq.test.client.rmq.RMQBroadCastConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BroadCastTwoConsumerFilterIT
extends BaseBroadCastIT {
    private static Logger logger = Logger.getLogger(BroadCastTwoConsumerSubTagIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = BroadCastTwoConsumerFilterIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = BroadCastTwoConsumerFilterIT.getProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseBroadCastIT.shutdown();
    }

    @Test
    public void testTwoConsumerFilter() {
        int msgSize = 40;
        String tag1 = "jueyin_tag_1";
        String tag2 = "jueyin_tag_2";
        RMQBroadCastConsumer consumer1 = BroadCastTwoConsumerFilterIT.getBroadCastConsumer(nsAddr, this.topic, tag1, (AbstractListener)new RMQNormalListener());
        RMQBroadCastConsumer consumer2 = BroadCastTwoConsumerFilterIT.getBroadCastConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, tag1, (AbstractListener)new RMQNormalListener());
        TestUtils.waitForSeconds((long)waitTime);
        this.producer.send(tag2, msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        this.producer.clearMsg();
        this.producer.send(tag1, msgSize);
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        consumer2.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

