/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.broadcast.tag;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.client.consumer.broadcast.BaseBroadCastIT;
import org.apache.rocketmq.test.client.consumer.broadcast.tag.BroadCastTwoConsumerSubTagIT;
import org.apache.rocketmq.test.client.rmq.RMQBroadCastConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BroadCastTwoConsumerSubDiffTagIT
extends BaseBroadCastIT {
    private static Logger logger = Logger.getLogger(BroadCastTwoConsumerSubTagIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = BroadCastTwoConsumerSubDiffTagIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = BroadCastTwoConsumerSubDiffTagIT.getProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseBroadCastIT.shutdown();
    }

    @Test
    public void testTwoConsumerSubDiffTag() {
        int msgSize = 40;
        String tag = "jueyin_tag";
        RMQBroadCastConsumer consumer1 = BroadCastTwoConsumerSubDiffTagIT.getBroadCastConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQBroadCastConsumer consumer2 = BroadCastTwoConsumerSubDiffTagIT.getBroadCastConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, tag, (AbstractListener)new RMQNormalListener());
        TestUtils.waitForSeconds((long)waitTime);
        this.producer.send(tag, msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        consumer2.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

