/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.cluster;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.balance.NormalMsgStaticBalanceIT;
import org.apache.rocketmq.test.client.mq.MQAsyncProducer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.clientinterface.AbstractMQProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.MQWait;
import org.apache.rocketmq.test.util.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DynamicAddConsumerIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(NormalMsgStaticBalanceIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = DynamicAddConsumerIT.initTopic();
        logger.info((Object)String.format("use topic: %s !", this.topic));
        this.producer = DynamicAddConsumerIT.getProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testAddOneConsumer() {
        int msgSize = 100;
        RMQNormalConsumer consumer1 = DynamicAddConsumerIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        MQAsyncProducer asyncDefaultMQProducer = new MQAsyncProducer((AbstractMQProducer)this.producer, (long)msgSize, 100);
        asyncDefaultMQProducer.start();
        TestUtils.waitForSeconds((long)waitTime);
        RMQNormalConsumer consumer2 = DynamicAddConsumerIT.getConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        asyncDefaultMQProducer.waitSendAll(waitTime * 6);
        MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        boolean recvAll = MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
    }

    @Test
    public void testAddTwoConsumer() {
        int msgSize = 100;
        RMQNormalConsumer consumer1 = DynamicAddConsumerIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        MQAsyncProducer asyncDefaultMQProducer = new MQAsyncProducer((AbstractMQProducer)this.producer, (long)msgSize, 100);
        asyncDefaultMQProducer.start();
        TestUtils.waitForSeconds((long)waitTime);
        RMQNormalConsumer consumer2 = DynamicAddConsumerIT.getConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumer3 = DynamicAddConsumerIT.getConsumer(nsAddr, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        asyncDefaultMQProducer.waitSendAll(waitTime * 6);
        MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener(), consumer3.getListener()});
        boolean recvAll = MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener(), consumer3.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
    }
}

