/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.tag;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.factory.MQMessageFactory;
import org.apache.rocketmq.test.factory.TagMessage;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TagMessageWithMulConsumerIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(TagMessageWith1ConsumerIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = TagMessageWithMulConsumerIT.initTopic();
        String consumerId = TagMessageWithMulConsumerIT.initConsumerGroup();
        logger.info((Object)String.format("use topic: %s; consumerId: %s !", this.topic, consumerId));
        this.producer = TagMessageWithMulConsumerIT.getProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSendTwoTag() {
        String tag1 = "jueyin1";
        String tag2 = "jueyin2";
        int msgSize = 10;
        RMQNormalConsumer consumerTag1 = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, tag1, (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumerTag2 = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, tag2, (AbstractListener)new RMQNormalListener());
        List tag1Msgs = MQMessageFactory.getRMQMessage((String)tag1, (String)this.topic, (int)msgSize);
        this.producer.send(tag1Msgs);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        List tag2Msgs = MQMessageFactory.getRMQMessage((String)tag2, (String)this.topic, (int)msgSize);
        this.producer.send(tag2Msgs);
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * 2), (long)this.producer.getAllUndupMsgBody().size());
        consumerTag1.getListener().waitForMessageConsume((Collection)MQMessageFactory.getMessageBody((List)tag1Msgs), consumeTime);
        consumerTag2.getListener().waitForMessageConsume((Collection)MQMessageFactory.getMessageBody((List)tag2Msgs), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerTag1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)MQMessageFactory.getMessageBody((List)tag1Msgs));
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerTag2.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)MQMessageFactory.getMessageBody((List)tag2Msgs));
    }

    @Test
    public void testSendMessagesWithTwoTag() {
        String[] tags = new String[]{"jueyin1", "jueyin2"};
        int msgSize = 10;
        TagMessage tagMessage = new TagMessage(tags, this.topic, msgSize);
        RMQNormalConsumer consumerTag1 = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, tags[0], (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumerTag2 = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, tags[1], (AbstractListener)new RMQNormalListener());
        List tagMsgs = tagMessage.getMixedTagMessages();
        this.producer.send(tagMsgs);
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * tags.length), (long)this.producer.getAllUndupMsgBody().size());
        consumerTag1.getListener().waitForMessageConsume((Collection)tagMessage.getMessageBodyByTag(tags[0]), consumeTime);
        consumerTag2.getListener().waitForMessageConsume((Collection)tagMessage.getMessageBodyByTag(tags[1]), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerTag1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)tagMessage.getMessageBodyByTag(tags[0]));
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerTag2.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)tagMessage.getMessageBodyByTag(tags[1]));
    }

    @Test
    public void testTwoConsumerOneMatchOneOtherMatchAll() {
        String[] tags = new String[]{"jueyin1", "jueyin2"};
        String sub1 = String.format("%s||%s", tags[0], tags[1]);
        String sub2 = String.format("%s|| noExist", tags[0]);
        int msgSize = 10;
        TagMessage tagMessage = new TagMessage(tags, this.topic, msgSize);
        RMQNormalConsumer consumerTag1 = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, sub1, (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumerTag2 = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, sub2, (AbstractListener)new RMQNormalListener());
        List tagMsgs = tagMessage.getMixedTagMessages();
        this.producer.send(tagMsgs);
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * tags.length), (long)this.producer.getAllUndupMsgBody().size());
        consumerTag1.getListener().waitForMessageConsume((Collection)tagMessage.getMessageBodyByTag(tags), consumeTime);
        consumerTag2.getListener().waitForMessageConsume((Collection)tagMessage.getMessageBodyByTag(tags[0]), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerTag1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)tagMessage.getAllTagMessageBody());
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerTag2.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)tagMessage.getMessageBodyByTag(tags[0]));
    }

    @Test
    public void testSubKindsOf() {
        String[] tags = new String[]{"jueyin1", "jueyin2"};
        String sub1 = String.format("%s||%s", tags[0], tags[1]);
        String sub2 = String.format("%s|| noExist", tags[0]);
        String sub3 = tags[0];
        String sub4 = "*";
        int msgSize = 10;
        RMQNormalConsumer consumerSubTwoMatchAll = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, sub1, (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumerSubTwoMachieOne = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, sub2, (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumerSubTag1 = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, sub3, (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumerSubAll = TagMessageWithMulConsumerIT.getConsumer(nsAddr, this.topic, sub4, (AbstractListener)new RMQNormalListener());
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        Collection msgsWithNoTag = this.producer.getMsgBodysCopy();
        TagMessage tagMessage = new TagMessage(tags, this.topic, msgSize);
        List tagMsgs = tagMessage.getMixedTagMessages();
        this.producer.send(tagMsgs);
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * 3), (long)this.producer.getAllUndupMsgBody().size());
        consumerSubTwoMatchAll.getListener().waitForMessageConsume((Collection)tagMessage.getMessageBodyByTag(tags), consumeTime);
        consumerSubTwoMachieOne.getListener().waitForMessageConsume((Collection)tagMessage.getMessageBodyByTag(tags[0]), consumeTime);
        consumerSubTag1.getListener().waitForMessageConsume((Collection)tagMessage.getMessageBodyByTag(tags[0]), consumeTime);
        consumerSubAll.getListener().waitForMessageConsume(MQMessageFactory.getMessage((Collection[])new Collection[]{msgsWithNoTag, tagMessage.getAllTagMessageBody()}), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerSubTwoMatchAll.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)tagMessage.getAllTagMessageBody());
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerSubTwoMachieOne.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)tagMessage.getMessageBodyByTag(tags[0]));
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerSubTag1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)tagMessage.getMessageBodyByTag(tags[0]));
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumerSubAll.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)MQMessageFactory.getMessage((Collection[])new Collection[]{msgsWithNoTag, tagMessage.getAllTagMessageBody()}));
    }
}

