/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.topic;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.factory.MQMessageFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.MQWait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MulConsumerMulTopicIT
extends BaseConf {
    private RMQNormalProducer producer = null;

    @Before
    public void setUp() {
        this.producer = MulConsumerMulTopicIT.getProducer(nsAddr, null);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSynSendMessage() {
        int msgSize = 10;
        String topic1 = MulConsumerMulTopicIT.initTopic();
        String topic2 = MulConsumerMulTopicIT.initTopic();
        RMQNormalConsumer consumer1 = MulConsumerMulTopicIT.getConsumer(nsAddr, topic1, "*", (AbstractListener)new RMQNormalListener());
        consumer1.subscribe(topic2, "*");
        RMQNormalConsumer consumer2 = MulConsumerMulTopicIT.getConsumer(nsAddr, consumer1.getConsumerGroup(), topic1, "*", (AbstractListener)new RMQNormalListener());
        consumer2.subscribe(topic2, "*");
        this.producer.send(MQMessageFactory.getMsg((String)topic1, (int)msgSize));
        this.producer.send(MQMessageFactory.getMsg((String)topic2, (int)msgSize));
        Assert.assertEquals((String)"Not all sent succeeded", (long)(msgSize * 2), (long)this.producer.getAllUndupMsgBody().size());
        boolean recvAll = MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
    }

    @Test
    public void testConsumeWithDiffTag() {
        int msgSize = 10;
        String topic1 = MulConsumerMulTopicIT.initTopic();
        String topic2 = MulConsumerMulTopicIT.initTopic();
        String tag = "jueyin_tag";
        RMQNormalConsumer consumer1 = MulConsumerMulTopicIT.getConsumer(nsAddr, topic1, "*", (AbstractListener)new RMQNormalListener());
        consumer1.subscribe(topic2, tag);
        RMQNormalConsumer consumer2 = MulConsumerMulTopicIT.getConsumer(nsAddr, consumer1.getConsumerGroup(), topic1, "*", (AbstractListener)new RMQNormalListener());
        consumer2.subscribe(topic2, tag);
        this.producer.send(MQMessageFactory.getMsg((String)topic1, (int)msgSize));
        this.producer.send(MQMessageFactory.getMsg((String)topic2, (int)msgSize, (String)tag));
        Assert.assertEquals((String)"Not all sent succeeded", (long)(msgSize * 2), (long)this.producer.getAllUndupMsgBody().size());
        boolean recvAll = MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
    }

    @Test
    public void testConsumeWithDiffTagAndFilter() {
        int msgSize = 10;
        String topic1 = MulConsumerMulTopicIT.initTopic();
        String topic2 = MulConsumerMulTopicIT.initTopic();
        String tag1 = "jueyin_tag_1";
        String tag2 = "jueyin_tag_2";
        RMQNormalConsumer consumer1 = MulConsumerMulTopicIT.getConsumer(nsAddr, topic1, "*", (AbstractListener)new RMQNormalListener());
        consumer1.subscribe(topic2, tag1);
        RMQNormalConsumer consumer2 = MulConsumerMulTopicIT.getConsumer(nsAddr, topic1, "*", (AbstractListener)new RMQNormalListener());
        consumer2.subscribe(topic2, tag1);
        this.producer.send(MQMessageFactory.getMsg((String)topic2, (int)msgSize, (String)tag2));
        this.producer.clearMsg();
        this.producer.send(MQMessageFactory.getMsg((String)topic1, (int)msgSize));
        this.producer.send(MQMessageFactory.getMsg((String)topic2, (int)msgSize, (String)tag1));
        boolean recvAll = MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
    }
}

