/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.topic;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.factory.MQMessageFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OneConsumerMulTopicIT
extends BaseConf {
    private RMQNormalProducer producer = null;

    @Before
    public void setUp() {
        this.producer = OneConsumerMulTopicIT.getProducer(nsAddr, null);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSynSendMessage() {
        int msgSize = 10;
        String topic1 = OneConsumerMulTopicIT.initTopic();
        String topic2 = OneConsumerMulTopicIT.initTopic();
        RMQNormalConsumer consumer = OneConsumerMulTopicIT.getConsumer(nsAddr, topic1, "*", (AbstractListener)new RMQNormalListener());
        consumer.subscribe(topic2, "*");
        this.producer.send(MQMessageFactory.getMsg((String)topic1, (int)msgSize));
        this.producer.send(MQMessageFactory.getMsg((String)topic2, (int)msgSize));
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * 2), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testConsumeWithDiffTag() {
        int msgSize = 10;
        String topic1 = OneConsumerMulTopicIT.initTopic();
        String topic2 = OneConsumerMulTopicIT.initTopic();
        String tag = "jueyin_tag";
        RMQNormalConsumer consumer = OneConsumerMulTopicIT.getConsumer(nsAddr, topic1, "*", (AbstractListener)new RMQNormalListener());
        consumer.subscribe(topic2, tag);
        this.producer.send(MQMessageFactory.getMsg((String)topic1, (int)msgSize));
        this.producer.send(MQMessageFactory.getMsg((String)topic2, (int)msgSize, (String)tag));
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * 2), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testConsumeWithDiffTagAndFilter() {
        int msgSize = 10;
        String topic1 = OneConsumerMulTopicIT.initTopic();
        String topic2 = OneConsumerMulTopicIT.initTopic();
        String tag1 = "jueyin_tag_1";
        String tag2 = "jueyin_tag_2";
        RMQNormalConsumer consumer = OneConsumerMulTopicIT.getConsumer(nsAddr, topic1, "*", (AbstractListener)new RMQNormalListener());
        consumer.subscribe(topic2, tag1);
        this.producer.send(MQMessageFactory.getMsg((String)topic2, (int)msgSize, (String)tag2));
        this.producer.clearMsg();
        this.producer.send(MQMessageFactory.getMsg((String)topic1, (int)msgSize));
        this.producer.send(MQMessageFactory.getMsg((String)topic2, (int)msgSize, (String)tag1));
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * 2), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

