/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.async;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQAsyncSendProducer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AsyncSendWithMessageQueueIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(TagMessageWith1ConsumerIT.class);
    private RMQAsyncSendProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = AsyncSendWithMessageQueueIT.initTopic();
        logger.info((Object)String.format("user topic[%s]!", this.topic));
        this.producer = AsyncSendWithMessageQueueIT.getAsyncProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testAsyncSendWithMQ() {
        int msgSize = 20;
        int queueId = 0;
        RMQNormalConsumer consumer = AsyncSendWithMessageQueueIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        MessageQueue mq = new MessageQueue(this.topic, broker1Name, queueId);
        this.producer.asyncSend(msgSize, mq);
        this.producer.waitForResponse(10000);
        Truth.assertThat((Integer)this.producer.getSuccessMsgCount()).isEqualTo((Object)msgSize);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        VerifyUtils.verifyMessageQueueId((int)queueId, (Collection)consumer.getListener().getAllOriginMsg());
        this.producer.clearMsg();
        consumer.clearMsg();
        this.producer.getSuccessSendResult().clear();
        mq = new MessageQueue(this.topic, broker2Name, queueId);
        this.producer.asyncSend(msgSize, mq);
        this.producer.waitForResponse(10000);
        Truth.assertThat((Integer)this.producer.getSuccessMsgCount()).isEqualTo((Object)msgSize);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        VerifyUtils.verifyMessageQueueId((int)queueId, (Collection)consumer.getListener().getAllOriginMsg());
    }
}

