/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.async;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQAsyncSendProducer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AsyncSendWithMessageQueueSelectorIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(TagMessageWith1ConsumerIT.class);
    private RMQAsyncSendProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = AsyncSendWithMessageQueueSelectorIT.initTopic();
        logger.info((Object)String.format("user topic[%s]!", this.topic));
        this.producer = AsyncSendWithMessageQueueSelectorIT.getAsyncProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSendWithSelector() {
        int msgSize = 20;
        boolean queueId = false;
        RMQNormalConsumer consumer = AsyncSendWithMessageQueueSelectorIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        this.producer.asyncSend(msgSize, new MessageQueueSelector(){

            public MessageQueue select(List<MessageQueue> list, Message message, Object o) {
                for (MessageQueue mq : list) {
                    if (mq.getQueueId() != 0 || !mq.getBrokerName().equals(broker1Name)) continue;
                    return mq;
                }
                return list.get(0);
            }
        });
        this.producer.waitForResponse(5000);
        Truth.assertThat((Integer)this.producer.getSuccessMsgCount()).isEqualTo((Object)msgSize);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        VerifyUtils.verifyMessageQueueId((int)0, (Collection)consumer.getListener().getAllOriginMsg());
        this.producer.clearMsg();
        consumer.clearMsg();
        this.producer.getSuccessSendResult().clear();
        this.producer.asyncSend(msgSize, new MessageQueueSelector(){

            public MessageQueue select(List<MessageQueue> list, Message message, Object o) {
                for (MessageQueue mq : list) {
                    if (mq.getQueueId() != 0 || !mq.getBrokerName().equals(broker2Name)) continue;
                    return mq;
                }
                return list.get(8);
            }
        });
        this.producer.waitForResponse(5000);
        Truth.assertThat((Integer)this.producer.getSuccessMsgCount()).isEqualTo((Object)msgSize);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        VerifyUtils.verifyMessageQueueId((int)0, (Collection)consumer.getListener().getAllOriginMsg());
    }
}

