/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.async;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQAsyncSendProducer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AsyncSendWithOnlySendCallBackIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(TagMessageWith1ConsumerIT.class);
    private RMQAsyncSendProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = AsyncSendWithOnlySendCallBackIT.initTopic();
        logger.info((Object)String.format("user topic[%s]!", this.topic));
        this.producer = AsyncSendWithOnlySendCallBackIT.getAsyncProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSendWithOnlyCallBack() {
        int msgSize = 20;
        RMQNormalConsumer consumer = AsyncSendWithOnlySendCallBackIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        this.producer.asyncSend(msgSize);
        this.producer.waitForResponse(10000);
        Truth.assertThat((Integer)this.producer.getSuccessMsgCount()).isEqualTo((Object)msgSize);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

