/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.batch;

import java.util.ArrayList;
import java.util.Random;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.factory.ProducerFactory;
import org.apache.rocketmq.test.util.RandomUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BatchSendIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(TagMessageWith1ConsumerIT.class);
    private String topic = null;
    private Random random = new Random();

    @Before
    public void setUp() {
        this.topic = BatchSendIT.initTopic();
        logger.info((Object)String.format("user topic[%s]!", this.topic));
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testBatchSend_ViewMessage() throws Exception {
        int i;
        ArrayList<Message> messageList = new ArrayList<Message>();
        int batchNum = 100;
        for (int i2 = 0; i2 < batchNum; ++i2) {
            messageList.add(new Message(this.topic, RandomUtils.getStringByUUID().getBytes()));
        }
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)nsAddr);
        SendResult sendResult = producer.send(messageList);
        Assert.assertEquals((Object)SendStatus.SEND_OK, (Object)sendResult.getSendStatus());
        String[] offsetIds = sendResult.getOffsetMsgId().split(",");
        String[] msgIds = sendResult.getMsgId().split(",");
        Assert.assertEquals((long)messageList.size(), (long)offsetIds.length);
        Assert.assertEquals((long)messageList.size(), (long)msgIds.length);
        Thread.sleep(2000L);
        for (i = 0; i < 3; ++i) {
            producer.viewMessage(offsetIds[this.random.nextInt(batchNum)]);
        }
        for (i = 0; i < 3; ++i) {
            producer.viewMessage(this.topic, msgIds[this.random.nextInt(batchNum)]);
        }
    }

    @Test
    public void testBatchSend_CheckProperties() throws Exception {
        ArrayList<Message> messageList = new ArrayList<Message>();
        Message message = new Message();
        message.setTopic(this.topic);
        message.setKeys("keys123");
        message.setTags("tags123");
        message.setWaitStoreMsgOK(false);
        message.setBuyerId("buyerid123");
        message.setFlag(123);
        message.setBody("body".getBytes());
        messageList.add(message);
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)nsAddr);
        SendResult sendResult = producer.send(messageList);
        Assert.assertEquals((Object)SendStatus.SEND_OK, (Object)sendResult.getSendStatus());
        String[] offsetIds = sendResult.getOffsetMsgId().split(",");
        String[] msgIds = sendResult.getMsgId().split(",");
        Assert.assertEquals((long)messageList.size(), (long)offsetIds.length);
        Assert.assertEquals((long)messageList.size(), (long)msgIds.length);
        Thread.sleep(2000L);
        MessageExt messageByOffset = producer.viewMessage(offsetIds[0]);
        MessageExt messageByMsgId = producer.viewMessage(this.topic, msgIds[0]);
        System.out.println(messageByOffset);
        System.out.println(messageByMsgId);
        Assert.assertEquals((Object)message.getTopic(), (Object)messageByMsgId.getTopic());
        Assert.assertEquals((Object)message.getTopic(), (Object)messageByOffset.getTopic());
        Assert.assertEquals((Object)message.getKeys(), (Object)messageByOffset.getKeys());
        Assert.assertEquals((Object)message.getKeys(), (Object)messageByMsgId.getKeys());
        Assert.assertEquals((Object)message.getTags(), (Object)messageByOffset.getTags());
        Assert.assertEquals((Object)message.getTags(), (Object)messageByMsgId.getTags());
        Assert.assertEquals((Object)message.isWaitStoreMsgOK(), (Object)messageByOffset.isWaitStoreMsgOK());
        Assert.assertEquals((Object)message.isWaitStoreMsgOK(), (Object)messageByMsgId.isWaitStoreMsgOK());
        Assert.assertEquals((Object)message.getBuyerId(), (Object)messageByOffset.getBuyerId());
        Assert.assertEquals((Object)message.getBuyerId(), (Object)messageByMsgId.getBuyerId());
        Assert.assertEquals((long)message.getFlag(), (long)messageByOffset.getFlag());
        Assert.assertEquals((long)message.getFlag(), (long)messageByMsgId.getFlag());
    }
}

