/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.exception.msg;

import com.google.common.truth.Truth;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.factory.MessageFactory;
import org.apache.rocketmq.test.factory.ProducerFactory;
import org.apache.rocketmq.test.util.RandomUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ChinaPropIT
extends BaseConf {
    private static DefaultMQProducer producer = null;
    private static String topic = null;

    @Before
    public void setUp() {
        producer = ProducerFactory.getRMQProducer((String)nsAddr);
        topic = ChinaPropIT.initTopic();
    }

    @After
    public void tearDown() {
        producer.shutdown();
    }

    @Test(expected=MQBrokerException.class)
    public void testSend20kChinaPropMsg() throws Exception {
        Message msg = MessageFactory.getRandomMessage((String)topic);
        msg.putUserProperty("key", RandomUtils.getCheseWord((int)32769));
        producer.send(msg);
    }

    @Test
    public void testSend10kChinaPropMsg() {
        Message msg = MessageFactory.getRandomMessage((String)topic);
        msg.putUserProperty("key", RandomUtils.getCheseWord((int)10240));
        SendResult sendResult = null;
        try {
            sendResult = producer.send(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Truth.assertThat((Comparable)sendResult.getSendStatus()).isEqualTo((Object)SendStatus.SEND_OK);
    }
}

