/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.oneway;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQAsyncSendProducer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OneWaySendIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(TagMessageWith1ConsumerIT.class);
    private RMQAsyncSendProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = OneWaySendIT.initTopic();
        logger.info((Object)String.format("user topic[%s]!", this.topic));
        this.producer = OneWaySendIT.getAsyncProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testOneWaySendWithOnlyMsgAsParam() {
        int msgSize = 20;
        RMQNormalConsumer consumer = OneWaySendIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
        this.producer.sendOneWay(msgSize);
        this.producer.waitForResponse(5000);
        Truth.assertThat((Integer)this.producer.getAllMsgBody().size()).isEqualTo((Object)msgSize);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

