/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.order;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.factory.MQMessageFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.order.RMQOrderListener;
import org.apache.rocketmq.test.message.MessageQueueMsg;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OrderMsgIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(OrderMsgIT.class);
    private RMQNormalProducer producer = null;
    private RMQNormalConsumer consumer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = OrderMsgIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = OrderMsgIT.getProducer(nsAddr, this.topic);
        this.consumer = OrderMsgIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQOrderListener());
    }

    @After
    public void tearDown() {
        OrderMsgIT.shutdown();
    }

    @Test
    public void testOrderMsg() {
        int msgSize = 10;
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        this.consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)this.consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)mqMsgs.getMsgBodys());
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)this.consumer.getListener()).getMsgs())).isEqualTo((Object)true);
    }

    @Test
    public void testSendOneQueue() {
        int msgSize = 20;
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(MQMessageFactory.getMessageQueues((MessageQueue[])new MessageQueue[]{(MessageQueue)mqs.get(0)}), msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        this.consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)this.consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)mqMsgs.getMsgBodys());
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)this.consumer.getListener()).getMsgs())).isEqualTo((Object)true);
    }

    @Test
    public void testSendRandomQueues() {
        int msgSize = 10;
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(MQMessageFactory.getMessageQueues((MessageQueue[])new MessageQueue[]{(MessageQueue)mqs.get(0), (MessageQueue)mqs.get(1), (MessageQueue)mqs.get(mqs.size() - 1)}), msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        this.consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)this.consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)mqMsgs.getMsgBodys());
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)this.consumer.getListener()).getMsgs())).isEqualTo((Object)true);
    }
}

