/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.order;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.producer.order.OrderMsgIT;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.order.RMQOrderListener;
import org.apache.rocketmq.test.message.MessageQueueMsg;
import org.apache.rocketmq.test.util.MQWait;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OrderMsgWithTagIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(OrderMsgIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = OrderMsgWithTagIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = OrderMsgWithTagIT.getProducer(nsAddr, this.topic);
    }

    @After
    public void tearDown() {
        OrderMsgWithTagIT.shutdown();
    }

    @Test
    public void testOrderMsgWithTagSubAll() {
        int msgSize = 10;
        String tag = "jueyin_tag";
        RMQNormalConsumer consumer = OrderMsgWithTagIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQOrderListener());
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize, tag);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)mqMsgs.getMsgBodys());
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer.getListener()).getMsgs())).isEqualTo((Object)true);
    }

    @Test
    public void testOrderMsgWithTagSubTag() {
        int msgSize = 5;
        String tag = "jueyin_tag";
        RMQNormalConsumer consumer = OrderMsgWithTagIT.getConsumer(nsAddr, this.topic, tag, (AbstractListener)new RMQOrderListener());
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize, tag);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)mqMsgs.getMsgBodys());
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer.getListener()).getMsgs())).isEqualTo((Object)true);
    }

    @Test
    public void testOrderMsgWithTag1AndTag2SubTag1() {
        int msgSize = 5;
        String tag1 = "jueyin_tag_1";
        String tag2 = "jueyin_tag_2";
        RMQNormalConsumer consumer = OrderMsgWithTagIT.getConsumer(nsAddr, this.topic, tag1, (AbstractListener)new RMQOrderListener());
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize, tag2);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        this.producer.clearMsg();
        mqMsgs = new MessageQueueMsg(mqs, msgSize, tag1);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)mqMsgs.getMsgBodys());
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer.getListener()).getMsgs())).isEqualTo((Object)true);
    }

    @Test
    public void testTwoConsumerSubTag() {
        int msgSize = 10;
        String tag1 = "jueyin_tag_1";
        String tag2 = "jueyin_tag_2";
        RMQNormalConsumer consumer1 = OrderMsgWithTagIT.getConsumer(nsAddr, this.topic, tag1, (AbstractListener)new RMQOrderListener("consumer1"));
        RMQNormalConsumer consumer2 = OrderMsgWithTagIT.getConsumer(nsAddr, this.topic, tag2, (AbstractListener)new RMQOrderListener("consumer2"));
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize, tag1);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        mqMsgs = new MessageQueueMsg(mqs, msgSize, tag2);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        boolean recvAll = MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer1.getListener()).getMsgs())).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer2.getListener()).getMsgs())).isEqualTo((Object)true);
    }

    @Test
    public void testConsumeTwoTag() {
        int msgSize = 10;
        String tag1 = "jueyin_tag_1";
        String tag2 = "jueyin_tag_2";
        RMQNormalConsumer consumer = OrderMsgWithTagIT.getConsumer(nsAddr, this.topic, String.format("%s||%s", tag1, tag2), (AbstractListener)new RMQOrderListener());
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize, tag1);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        mqMsgs = new MessageQueueMsg(mqs, msgSize, tag2);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        boolean recvAll = MQWait.waitConsumeAll((int)consumeTime, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer.getListener()).getMsgs())).isEqualTo((Object)true);
    }
}

