/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.querymsg;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.common.message.MessageClientExt;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryMsgByIdIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(QueryMsgByIdIT.class);
    private RMQNormalProducer producer = null;
    private RMQNormalConsumer consumer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = QueryMsgByIdIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = QueryMsgByIdIT.getProducer(nsAddr, this.topic);
        this.consumer = QueryMsgByIdIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
    }

    @After
    public void tearDown() {
        QueryMsgByIdIT.shutdown();
    }

    @Test
    public void testQueryMsg() {
        int msgSize = 20;
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        this.consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Assert.assertEquals((String)"Not all are consumed", (long)0L, (long)VerifyUtils.verify((Collection)this.producer.getAllMsgBody(), (Collection)this.consumer.getListener().getAllMsgBody()));
        MessageExt recvMsg = (MessageExt)this.consumer.getListener().getFirstMsg();
        MessageExt queryMsg = null;
        try {
            TestUtils.waitForMoment((long)3000L);
            queryMsg = this.producer.getProducer().viewMessage(((MessageClientExt)recvMsg).getOffsetMsgId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Truth.assertThat(queryMsg).isNotNull();
        Truth.assertThat((String)new String(queryMsg.getBody())).isEqualTo((Object)new String(recvMsg.getBody()));
    }
}

