/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.delay;

import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.client.consumer.balance.NormalMsgStaticBalanceIT;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.delay.DelayConf;
import org.apache.rocketmq.test.factory.MQMessageFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQDelayListner;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NormalMsgDelayIT
extends DelayConf {
    private static Logger logger = Logger.getLogger(NormalMsgStaticBalanceIT.class);
    protected int msgSize = 100;
    private RMQNormalProducer producer = null;
    private RMQNormalConsumer consumer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = NormalMsgDelayIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = NormalMsgDelayIT.getProducer(nsAddr, this.topic);
        this.consumer = NormalMsgDelayIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQDelayListner());
    }

    @After
    public void tearDown() {
        DelayConf.shutdown();
    }

    @Test
    public void testDelayLevell() {
        int delayLevel = 1;
        List delayMsgs = MQMessageFactory.getDelayMsg((String)this.topic, (int)delayLevel, (int)this.msgSize);
        this.producer.send(delayMsgs);
        Assert.assertEquals((String)"Not all sent succeeded", (long)this.msgSize, (long)this.producer.getAllUndupMsgBody().size());
        this.consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Assert.assertEquals((String)"Not all are consumed", (long)0L, (long)VerifyUtils.verify((Collection)this.producer.getAllMsgBody(), (Collection)this.consumer.getListener().getAllMsgBody()));
        Assert.assertEquals((String)"Timer is not correct", (Object)true, (Object)VerifyUtils.verifyDelay((long)(DELAY_LEVEL[delayLevel - 1] * 1000), (Collection)((RMQDelayListner)this.consumer.getListener()).getMsgDelayTimes()));
    }

    @Test
    public void testDelayLevel2() {
        int delayLevel = 2;
        List delayMsgs = MQMessageFactory.getDelayMsg((String)this.topic, (int)delayLevel, (int)this.msgSize);
        this.producer.send(delayMsgs);
        Assert.assertEquals((String)"Not all sent succeeded", (long)this.msgSize, (long)this.producer.getAllUndupMsgBody().size());
        this.consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), DELAY_LEVEL[delayLevel - 1] * 1000 * 2);
        Assert.assertEquals((String)"Not all are consumed", (long)0L, (long)VerifyUtils.verify((Collection)this.producer.getAllMsgBody(), (Collection)this.consumer.getListener().getAllMsgBody()));
        Assert.assertEquals((String)"Timer is not correct", (Object)true, (Object)VerifyUtils.verifyDelay((long)(DELAY_LEVEL[delayLevel - 1] * 1000), (Collection)((RMQDelayListner)this.consumer.getListener()).getMsgDelayTimes()));
    }

    @Test
    public void testDelayLevel3() {
        int delayLevel = 3;
        List delayMsgs = MQMessageFactory.getDelayMsg((String)this.topic, (int)delayLevel, (int)this.msgSize);
        this.producer.send(delayMsgs);
        Assert.assertEquals((String)"Not all are sent", (long)this.msgSize, (long)this.producer.getAllUndupMsgBody().size());
        this.consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), DELAY_LEVEL[delayLevel - 1] * 1000 * 2);
        Assert.assertEquals((String)"Not all are consumed", (long)0L, (long)VerifyUtils.verify((Collection)this.producer.getAllMsgBody(), (Collection)this.consumer.getListener().getAllMsgBody()));
        Assert.assertEquals((String)"Timer is not correct", (Object)true, (Object)VerifyUtils.verifyDelay((long)(DELAY_LEVEL[delayLevel - 1] * 1000), (Collection)((RMQDelayListner)this.consumer.getListener()).getMsgDelayTimes()));
    }

    @Test
    public void testDelayLevel4() {
        int delayLevel = 4;
        List delayMsgs = MQMessageFactory.getDelayMsg((String)this.topic, (int)delayLevel, (int)this.msgSize);
        this.producer.send(delayMsgs);
        Assert.assertEquals((String)"Not all are sent", (long)this.msgSize, (long)this.producer.getAllUndupMsgBody().size());
        this.consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), DELAY_LEVEL[delayLevel - 1] * 1000 * 2);
        Assert.assertEquals((String)"Not all are consumed", (long)0L, (long)VerifyUtils.verify((Collection)this.producer.getAllMsgBody(), (Collection)this.consumer.getListener().getAllMsgBody()));
        Assert.assertEquals((String)"Timer is not correct", (Object)true, (Object)VerifyUtils.verifyDelay((long)(DELAY_LEVEL[delayLevel - 1] * 1000), (Collection)((RMQDelayListner)this.consumer.getListener()).getMsgDelayTimes()));
    }
}

