/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.smoke;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NormalMessageSendAndRecvIT
extends BaseConf {
    private static Logger logger = Logger.getLogger(NormalMessageSendAndRecvIT.class);
    private RMQNormalConsumer consumer = null;
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = NormalMessageSendAndRecvIT.initTopic();
        logger.info((Object)String.format("use topic: %s;", this.topic));
        this.producer = NormalMessageSendAndRecvIT.getProducer(nsAddr, this.topic);
        this.consumer = NormalMessageSendAndRecvIT.getConsumer(nsAddr, this.topic, "*", (AbstractListener)new RMQNormalListener());
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSynSendMessage() {
        int msgSize = 10;
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        this.consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), consumeTime);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)this.consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

