/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.processor.server;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchLogHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchLogHandler.class);
    private static final BlockingQueue<String> LOG_QUEUE = new ArrayBlockingQueue<String>(10240);
    public static final BatchLogHandler INSTANCE = new BatchLogHandler();
    private static final int MAX_LOG_SEND_THREAD = 1;
    private static final int MAX_LOG_TAKE_SIZE = 1024;
    private static final long KEEP_ALIVE_TIME = 0L;
    private static final String THREAD_PREFIX = "batchLoggerPrint";
    private static final long BUSY_SLEEP_MILLS = 5L;

    public boolean writeLog(String log) {
        try {
            LOG_QUEUE.put(log);
        }
        catch (InterruptedException e) {
            LOGGER.error("put message to logQueue error: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    static {
        ThreadPoolExecutor mergeSendExecutorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(THREAD_PREFIX, 1, true));
        mergeSendExecutorService.submit(new BatchLogRunnable());
    }

    static class BatchLogRunnable
    implements Runnable {
        BatchLogRunnable() {
        }

        @Override
        public void run() {
            ArrayList logList = new ArrayList();
            while (true) {
                try {
                    while (true) {
                        logList.add(LOG_QUEUE.take());
                        LOG_QUEUE.drainTo(logList, 1024);
                        if (LOGGER.isInfoEnabled()) {
                            for (String str : logList) {
                                LOGGER.info(str);
                            }
                        }
                        logList.clear();
                        TimeUnit.MILLISECONDS.sleep(5L);
                    }
                }
                catch (InterruptedException exx) {
                    LOGGER.error("batch log busy sleep error:{}", (Object)exx.getMessage(), (Object)exx);
                    continue;
                }
                break;
            }
        }
    }
}

