/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.serializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializerServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerServiceLoader.class);
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final SerializerType[] DEFAULT_SERIALIZER_TYPE = new SerializerType[]{SerializerType.SEATA, SerializerType.PROTOBUF, SerializerType.KRYO, SerializerType.HESSIAN};
    private static final String SPLIT_CHAR = ",";
    private static final String PROTOBUF_SERIALIZER_CLASS_NAME = "org.apache.seata.serializer.protobuf.ProtobufSerializer";

    private SerializerServiceLoader() {
    }

    public static Serializer load(SerializerType type) throws EnhancedServiceNotFoundException {
        if (type == SerializerType.PROTOBUF) {
            try {
                ReflectionUtil.getClassByName(PROTOBUF_SERIALIZER_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                throw new EnhancedServiceNotFoundException("'ProtobufSerializer' not found. Please manually reference 'org.apache.seata:seata-serializer-protobuf' dependency ", e);
            }
        }
        return EnhancedServiceLoader.load(Serializer.class, type.name());
    }

    public static List<SerializerType> getSupportedSerializers() {
        String[] serializerNameArray;
        ArrayList<SerializerType> supportedSerializers = new ArrayList<SerializerType>();
        String defaultSupportSerializers = Arrays.stream(DEFAULT_SERIALIZER_TYPE).map(Enum::name).collect(Collectors.joining(SPLIT_CHAR));
        String serializerNames = CONFIG.getConfig("transport.serialization", defaultSupportSerializers);
        for (String serializerName : serializerNameArray = serializerNames.split(SPLIT_CHAR)) {
            try {
                SerializerType serializerType = SerializerType.getByName(serializerName);
                supportedSerializers.add(serializerType);
            }
            catch (IllegalArgumentException ignore) {
                LOGGER.warn("Invalid serializer name: " + serializerName);
            }
        }
        return supportedSerializers.stream().distinct().collect(Collectors.toList());
    }

    public static SerializerType getDefaultSerializerType() {
        return SerializerServiceLoader.getSupportedSerializers().get(0);
    }
}

