/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.grpc.interceptor.server;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Collections;
import java.util.HashMap;
import org.apache.seata.integration.grpc.interceptor.GrpcHeaderKey;
import org.apache.seata.integration.grpc.interceptor.server.ServerListenerProxy;

public class ServerTransactionInterceptor
implements ServerInterceptor {
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        String xid = this.getRpcXid(metadata);
        String branchName = this.getBranchName(metadata);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("TX_BRANCH_TYPE", branchName);
        return new ServerListenerProxy(xid, Collections.unmodifiableMap(context), serverCallHandler.startCall(serverCall, metadata));
    }

    private String getRpcXid(Metadata metadata) {
        String rpcXid = (String)metadata.get(GrpcHeaderKey.XID_HEADER_KEY);
        if (rpcXid == null) {
            rpcXid = (String)metadata.get(GrpcHeaderKey.XID_HEADER_KEY_LOWERCASE);
        }
        return rpcXid;
    }

    private String getBranchName(Metadata metadata) {
        return (String)metadata.get(GrpcHeaderKey.BRANCH_HEADER_KEY);
    }
}

