/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.hsf;

import com.taobao.hsf.context.RPCContext;
import com.taobao.hsf.invocation.Invocation;
import com.taobao.hsf.invocation.InvocationHandler;
import com.taobao.hsf.invocation.RPCResult;
import com.taobao.hsf.invocation.filter.ClientFilter;
import com.taobao.hsf.util.concurrent.ListenableFuture;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsfTransactionConsumerFilter
implements ClientFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HsfTransactionConsumerFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RPCResult> invoke(InvocationHandler nextHandler, Invocation invocation) throws Throwable {
        String xid = RootContext.getXID();
        BranchType branchType = RootContext.getBranchType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("xid in RootContext[{}], branchType in RootContext[{}]", (Object)xid, (Object)branchType);
        }
        if (xid != null) {
            RPCContext.getClientContext().putAttachment("TX_XID", (Object)xid);
            RPCContext.getClientContext().putAttachment("TX_BRANCH_TYPE", (Object)branchType.name());
        }
        try {
            ListenableFuture listenableFuture = nextHandler.invoke(invocation);
            return listenableFuture;
        }
        finally {
            RPCContext.getClientContext().removeAttachment("TX_XID");
            RPCContext.getClientContext().removeAttachment("TX_BRANCH_TYPE");
        }
    }

    public void onResponse(Invocation invocation, RPCResult rpcResult) {
    }
}

