/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.rocketmq;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.integration.rocketmq.SeataMQProducer;
import org.apache.seata.integration.rocketmq.TCCRocketMQ;
import org.apache.seata.rm.tcc.api.BusinessActionContext;
import org.apache.seata.rm.tcc.api.BusinessActionContextUtil;
import org.apache.seata.rm.tcc.api.LocalTCC;
import org.apache.seata.rm.tcc.api.TwoPhaseBusinessAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LocalTCC
public class TCCRocketMQImpl
implements TCCRocketMQ {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCCRocketMQImpl.class);
    private static final String ROCKET_MSG_KEY = "ROCKET_MSG";
    private static final String ROCKET_SEND_RESULT_KEY = "ROCKET_SEND_RESULT";
    private SeataMQProducer producer;
    private DefaultMQProducerImpl producerImpl;

    @Override
    public void setProducer(SeataMQProducer producer) {
        this.producer = producer;
        this.producerImpl = producer.getDefaultMQProducerImpl();
    }

    @Override
    @TwoPhaseBusinessAction(name="tccRocketMQ")
    public SendResult prepare(Message message, long timeout) throws MQClientException {
        BusinessActionContext context = BusinessActionContextUtil.getContext();
        LOGGER.info("RocketMQ message send prepare, xid = {}", (Object)context.getXid());
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        SendResult sendResult = this.producer.doSendMessageInTransaction(message, timeout, context.getXid(), context.getBranchId());
        message.setDeliverTimeMs(0L);
        params.put(ROCKET_MSG_KEY, message);
        params.put(ROCKET_SEND_RESULT_KEY, sendResult);
        BusinessActionContextUtil.addContext(params);
        return sendResult;
    }

    @Override
    public boolean commit(BusinessActionContext context) throws UnknownHostException, MQBrokerException, RemotingException, InterruptedException, TimeoutException, TransactionException {
        Message message = context.getActionContext(ROCKET_MSG_KEY, Message.class);
        SendResult sendResult = context.getActionContext(ROCKET_SEND_RESULT_KEY, SendResult.class);
        if (message == null || sendResult == null) {
            throw new TransactionException("TCCRocketMQ commit but cannot find message and sendResult");
        }
        this.producerImpl.endTransaction(message, sendResult, LocalTransactionState.COMMIT_MESSAGE, null);
        LOGGER.info("RocketMQ message send commit, xid = {}, branchId = {}", (Object)context.getXid(), (Object)context.getBranchId());
        return true;
    }

    @Override
    public boolean rollback(BusinessActionContext context) throws UnknownHostException, MQBrokerException, RemotingException, InterruptedException, TransactionException {
        Message message = context.getActionContext(ROCKET_MSG_KEY, Message.class);
        SendResult sendResult = context.getActionContext(ROCKET_SEND_RESULT_KEY, SendResult.class);
        if (message == null || sendResult == null) {
            LOGGER.error("TCCRocketMQ rollback but cannot find message and sendResult");
        }
        this.producerImpl.endTransaction(message, sendResult, LocalTransactionState.ROLLBACK_MESSAGE, null);
        LOGGER.info("RocketMQ message send rollback, xid = {}, branchId = {}", (Object)context.getXid(), (Object)context.getBranchId());
        return true;
    }
}

