/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.fence.config;

import java.time.Duration;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.time.DateUtils;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.core.rpc.Disposable;
import org.apache.seata.integration.tx.api.fence.DefaultCommonFenceHandler;
import org.apache.seata.integration.tx.api.fence.store.db.CommonFenceStoreDataBaseDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFenceConfig
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonFenceConfig.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Duration MAX_PERIOD = Duration.ofSeconds(Integer.MAX_VALUE);
    private Duration cleanPeriod = Duration.ofDays(1L);
    private String logTableName = "tcc_fence_log";
    private final ScheduledThreadPoolExecutor commonFenceClean = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("CommonFenceClean", 1));

    public AtomicBoolean getInitialized() {
        return this.initialized;
    }

    public void setCleanPeriod(Duration cleanPeriod) {
        this.cleanPeriod = cleanPeriod;
    }

    public void setLogTableName(String logTableName) {
        this.logTableName = logTableName;
    }

    public void initCleanTask() {
        try {
            if (this.cleanPeriod.isZero() || this.cleanPeriod.isNegative()) {
                LOGGER.info("Common fence log clean task is not started, cleanPeriod is:{}", (Object)this.cleanPeriod);
                return;
            }
            long periodSeconds = this.cleanPeriod.compareTo(MAX_PERIOD) >= 0 ? Integer.MAX_VALUE : this.cleanPeriod.toMillis() / 1000L;
            this.commonFenceClean.scheduleWithFixedDelay(() -> {
                Date timeBefore = null;
                try {
                    timeBefore = DateUtils.addSeconds((Date)new Date(), (int)(-((int)periodSeconds)));
                    int deletedRowCount = DefaultCommonFenceHandler.get().deleteFenceByDate(timeBefore);
                    if (deletedRowCount > 0) {
                        LOGGER.info("Common fence clean task executed success, timeBefore: {}, deleted row count: {}", (Object)timeBefore, (Object)deletedRowCount);
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.error("Delete common fence log failed, timeBefore: {}", timeBefore, (Object)e);
                }
            }, new Random(System.currentTimeMillis()).nextInt(60), periodSeconds, TimeUnit.SECONDS);
            LOGGER.info("Common fence log clean task start success, cleanPeriod:{}", (Object)this.cleanPeriod);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Common fence log clean period only supports positive integers, clean task start failed");
        }
    }

    @Override
    public void destroy() {
        this.commonFenceClean.shutdown();
    }

    public void init() {
        if (this.logTableName != null) {
            CommonFenceStoreDataBaseDAO.getInstance().setLogTableName(this.logTableName);
        }
        this.initCleanTask();
    }
}

