/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.remoting.parser;

import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.integration.tx.api.remoting.RemotingDesc;
import org.apache.seata.integration.tx.api.remoting.parser.AbstractedRemotingParser;

public class HSFRemotingParser
extends AbstractedRemotingParser {
    private static volatile boolean isHsf;

    @Override
    public boolean isRemoting(Object bean, String beanName) {
        return isHsf && (this.isReference(bean, beanName) || this.isService(bean, beanName));
    }

    @Override
    public boolean isReference(Object bean, String beanName) {
        String beanClassName = bean.getClass().getName();
        return isHsf && "com.taobao.hsf.app.spring.util.HSFSpringConsumerBean".equals(beanClassName);
    }

    @Override
    public boolean isService(Object bean, String beanName) {
        String beanClassName = bean.getClass().getName();
        return isHsf && "com.taobao.hsf.app.spring.util.HSFSpringProviderBean".equals(beanClassName);
    }

    @Override
    public boolean isService(Class<?> beanClass) throws FrameworkException {
        String beanClassName = beanClass.getName();
        return isHsf && "com.taobao.hsf.app.spring.util.HSFSpringProviderBean".equals(beanClassName);
    }

    @Override
    public RemotingDesc getServiceDesc(Object bean, String beanName) throws FrameworkException {
        if (!this.isRemoting(bean, beanName)) {
            return null;
        }
        try {
            if (this.isReference(bean, beanName)) {
                Object consumerBean = ReflectionUtil.getFieldValue(bean, "consumerBean");
                Object metadata = ReflectionUtil.invokeMethod(consumerBean, "getMetadata");
                Class interfaceClass = (Class)ReflectionUtil.invokeMethod(metadata, "getIfClazz");
                String interfaceClassName = (String)ReflectionUtil.invokeMethod(metadata, "getInterfaceName");
                String uniqueId = (String)ReflectionUtil.invokeMethod(metadata, "getVersion");
                String group = (String)ReflectionUtil.invokeMethod(metadata, "getGroup");
                RemotingDesc serviceBeanDesc = new RemotingDesc();
                serviceBeanDesc.setServiceClass(interfaceClass);
                serviceBeanDesc.setServiceClassName(interfaceClassName);
                serviceBeanDesc.setUniqueId(uniqueId);
                serviceBeanDesc.setGroup(group);
                serviceBeanDesc.setProtocol((short)8);
                serviceBeanDesc.setReference(this.isReference(bean, beanName));
                serviceBeanDesc.setService(this.isService(bean, beanName));
                return serviceBeanDesc;
            }
            if (this.isService(bean, beanName)) {
                Object consumerBean = ReflectionUtil.getFieldValue(bean, "providerBean");
                Object metadata = ReflectionUtil.invokeMethod(consumerBean, "getMetadata");
                String interfaceClassName = (String)ReflectionUtil.invokeMethod(metadata, "getInterfaceName");
                Class<?> interfaceClass = Class.forName(interfaceClassName);
                String uniqueId = (String)ReflectionUtil.invokeMethod(metadata, "getVersion");
                String group = (String)ReflectionUtil.invokeMethod(metadata, "getGroup");
                RemotingDesc serviceBeanDesc = new RemotingDesc();
                serviceBeanDesc.setServiceClass(interfaceClass);
                serviceBeanDesc.setServiceClassName(interfaceClassName);
                serviceBeanDesc.setUniqueId(uniqueId);
                serviceBeanDesc.setGroup(group);
                Object targetBean = ReflectionUtil.getFieldValue(metadata, "target");
                serviceBeanDesc.setTargetBean(targetBean);
                serviceBeanDesc.setProtocol((short)8);
                serviceBeanDesc.setReference(this.isReference(bean, beanName));
                serviceBeanDesc.setService(this.isService(bean, beanName));
                return serviceBeanDesc;
            }
        }
        catch (Throwable t) {
            throw new FrameworkException(t);
        }
        return null;
    }

    @Override
    public short getProtocol() {
        return 8;
    }

    static {
        try {
            Class.forName("com.taobao.hsf.app.api.util.HSFApiConsumerBean");
            Class.forName("com.taobao.hsf.app.api.util.HSFApiProviderBean");
            Class.forName("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean");
            Class.forName("com.taobao.hsf.app.spring.util.HSFSpringProviderBean");
            isHsf = true;
        }
        catch (ClassNotFoundException e) {
            isHsf = false;
        }
    }
}

