/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exec.DeleteExecutor;
import org.apache.seata.rm.datasource.exec.Executor;
import org.apache.seata.rm.datasource.exec.InsertExecutor;
import org.apache.seata.rm.datasource.exec.MultiExecutor;
import org.apache.seata.rm.datasource.exec.PlainExecutor;
import org.apache.seata.rm.datasource.exec.SelectForUpdateExecutor;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.rm.datasource.exec.UpdateExecutor;
import org.apache.seata.rm.datasource.exec.mariadb.MariadbInsertOnDuplicateUpdateExecutor;
import org.apache.seata.rm.datasource.exec.mariadb.MariadbUpdateJoinExecutor;
import org.apache.seata.rm.datasource.exec.mysql.MySQLInsertOnDuplicateUpdateExecutor;
import org.apache.seata.rm.datasource.exec.mysql.MySQLUpdateJoinExecutor;
import org.apache.seata.rm.datasource.exec.polardbx.PolarDBXInsertOnDuplicateUpdateExecutor;
import org.apache.seata.rm.datasource.exec.polardbx.PolarDBXUpdateJoinExecutor;
import org.apache.seata.rm.datasource.exec.sqlserver.SqlServerDeleteExecutor;
import org.apache.seata.rm.datasource.exec.sqlserver.SqlServerSelectForUpdateExecutor;
import org.apache.seata.rm.datasource.exec.sqlserver.SqlServerUpdateExecutor;
import org.apache.seata.rm.datasource.sql.SQLVisitorFactory;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.SQLType;

public class ExecuteTemplate {
    public static <T, S extends Statement> T execute(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        return ExecuteTemplate.execute(null, statementProxy, statementCallback, args);
    }

    public static <T, S extends Statement> T execute(List<SQLRecognizer> sqlRecognizers, StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        Object rs;
        Executor executor;
        if (!RootContext.requireGlobalLock() && BranchType.AT != RootContext.getBranchType()) {
            return statementCallback.execute(statementProxy.getTargetStatement(), args);
        }
        String dbType = statementProxy.getConnectionProxy().getDbType();
        if (CollectionUtils.isEmpty(sqlRecognizers)) {
            sqlRecognizers = SQLVisitorFactory.get(statementProxy.getTargetSQL(), dbType);
        }
        if (CollectionUtils.isEmpty(sqlRecognizers)) {
            executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
        } else if (sqlRecognizers.size() == 1) {
            SQLRecognizer sqlRecognizer = sqlRecognizers.get(0);
            block1 : switch (sqlRecognizer.getSQLType()) {
                case INSERT: {
                    executor = EnhancedServiceLoader.load(InsertExecutor.class, dbType, new Class[]{StatementProxy.class, StatementCallback.class, SQLRecognizer.class}, new Object[]{statementProxy, statementCallback, sqlRecognizer});
                    break;
                }
                case UPDATE: {
                    if ("sqlserver".equalsIgnoreCase(dbType)) {
                        executor = new SqlServerUpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                        break;
                    }
                    executor = new UpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case DELETE: {
                    if ("sqlserver".equalsIgnoreCase(dbType)) {
                        executor = new SqlServerDeleteExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                        break;
                    }
                    executor = new DeleteExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case SELECT_FOR_UPDATE: {
                    if ("sqlserver".equalsIgnoreCase(dbType)) {
                        executor = new SqlServerSelectForUpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                        break;
                    }
                    executor = new SelectForUpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case INSERT_ON_DUPLICATE_UPDATE: {
                    switch (dbType) {
                        case "mysql": {
                            executor = new MySQLInsertOnDuplicateUpdateExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                            break block1;
                        }
                        case "mariadb": {
                            executor = new MariadbInsertOnDuplicateUpdateExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                            break block1;
                        }
                        case "polardb-x": {
                            executor = new PolarDBXInsertOnDuplicateUpdateExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                            break block1;
                        }
                    }
                    throw new NotSupportYetException(dbType + " not support to INSERT_ON_DUPLICATE_UPDATE");
                }
                case UPDATE_JOIN: {
                    switch (dbType) {
                        case "mysql": {
                            executor = new MySQLUpdateJoinExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                            break block1;
                        }
                        case "mariadb": {
                            executor = new MariadbUpdateJoinExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                            break block1;
                        }
                        case "polardb-x": {
                            executor = new PolarDBXUpdateJoinExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                            break block1;
                        }
                    }
                    throw new NotSupportYetException(dbType + " not support to " + SQLType.UPDATE_JOIN.name());
                }
                default: {
                    executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
                }
            }
        } else {
            executor = new MultiExecutor<T, S>(statementProxy, statementCallback, sqlRecognizers);
        }
        try {
            rs = executor.execute(args);
        }
        catch (Throwable ex2) {
            SQLException ex2;
            if (!(ex2 instanceof SQLException)) {
                ex2 = new SQLException(ex2);
            }
            throw (SQLException)ex2;
        }
        return rs;
    }
}

