/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec;

import org.apache.seata.common.util.NumberUtils;
import org.apache.seata.config.CachedConfigurationChangeListener;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.context.GlobalLockConfigHolder;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.model.GlobalLockConfig;
import org.apache.seata.rm.datasource.exec.LockConflictException;
import org.apache.seata.rm.datasource.exec.LockWaitTimeoutException;

public class LockRetryController {
    private static final GlobalConfig LISTENER = new GlobalConfig();
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private int lockRetryInterval = this.getLockRetryInterval();
    private int lockRetryTimes = this.getLockRetryTimes();

    public void sleep(Exception e) throws LockWaitTimeoutException {
        if (--this.lockRetryTimes < 0 || e instanceof LockConflictException && ((LockConflictException)e).getCode() == TransactionExceptionCode.LockKeyConflictFailFast) {
            throw new LockWaitTimeoutException("Global lock wait timeout", e);
        }
        try {
            Thread.sleep(this.lockRetryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    int getLockRetryInterval() {
        int configInterval;
        GlobalLockConfig config = GlobalLockConfigHolder.getCurrentGlobalLockConfig();
        if (config != null && (configInterval = config.getLockRetryInterval()) > 0) {
            return configInterval;
        }
        return LISTENER.getGlobalLockRetryInterval();
    }

    int getLockRetryTimes() {
        int configTimes;
        GlobalLockConfig config = GlobalLockConfigHolder.getCurrentGlobalLockConfig();
        if (config != null && (configTimes = config.getLockRetryTimes()) >= 0) {
            return configTimes;
        }
        return LISTENER.getGlobalLockRetryTimes();
    }

    static {
        CONFIG.addConfigListener("client.rm.lock.retryInterval", LISTENER);
        CONFIG.addConfigListener("client.rm.lock.retryTimes", LISTENER);
    }

    static class GlobalConfig
    implements CachedConfigurationChangeListener {
        private volatile int globalLockRetryInterval;
        private volatile int globalLockRetryTimes;
        private final int defaultRetryInterval = 10;
        private final int defaultRetryTimes = 30;

        public GlobalConfig() {
            Configuration configuration = ConfigurationFactory.getInstance();
            this.globalLockRetryInterval = configuration.getInt("client.rm.lock.retryInterval", 10);
            this.globalLockRetryTimes = configuration.getInt("client.rm.lock.retryTimes", 30);
        }

        @Override
        public void onChangeEvent(ConfigurationChangeEvent event) {
            String dataId = event.getDataId();
            String newValue = event.getNewValue();
            if ("client.rm.lock.retryInterval".equals(dataId)) {
                this.globalLockRetryInterval = NumberUtils.toInt(newValue, 10);
            }
            if ("client.rm.lock.retryTimes".equals(dataId)) {
                this.globalLockRetryTimes = NumberUtils.toInt(newValue, 30);
            }
        }

        public int getGlobalLockRetryInterval() {
            return this.globalLockRetryInterval;
        }

        public int getGlobalLockRetryTimes() {
            return this.globalLockRetryTimes;
        }
    }
}

