/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.util;

import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.MySqlUtils;
import com.alibaba.druid.util.PGUtils;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import org.apache.seata.rm.BaseDataSourceResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAUtils.class);

    public static String getDbType(String jdbcUrl, String driverClassName) {
        return JdbcUtils.getDbType((String)jdbcUrl, (String)driverClassName);
    }

    public static XAConnection createXAConnection(Connection physicalConn, BaseDataSourceResource dataSourceResource) throws SQLException {
        return XAUtils.createXAConnection(physicalConn, dataSourceResource.getDriver(), dataSourceResource.getDbType());
    }

    public static XAConnection createXAConnection(Connection physicalConn, Driver driver, String dbType) throws SQLException {
        if ("mysql".equals(dbType)) {
            return MySqlUtils.createXAConnection((Driver)driver, (Connection)physicalConn);
        }
        try {
            switch (dbType) {
                case "oracle": {
                    String physicalConnClassName = physicalConn.getClass().getName();
                    if ("oracle.jdbc.driver.T4CConnection".equals(physicalConnClassName)) {
                        return XAUtils.createXAConnection(physicalConn, "oracle.jdbc.driver.T4CXAConnection", dbType);
                    }
                    return XAUtils.createXAConnection(physicalConn, "oracle.jdbc.xa.client.OracleXAConnection", dbType);
                }
                case "mariadb": {
                    return XAUtils.createXAConnection(physicalConn, "org.mariadb.jdbc.MariaXaConnection", dbType);
                }
                case "postgresql": {
                    return PGUtils.createXAConnection((Connection)physicalConn);
                }
            }
            throw new SQLException("xa not support dbType: " + dbType);
        }
        catch (Exception xae) {
            throw new SQLException("create xaConnection error", xae);
        }
    }

    private static XAConnection createXAConnection(Connection physicalConnection, String xaConnectionClassName, String dbType) throws XAException, SQLException {
        try {
            Class<?> xaConnectionClass = Class.forName(xaConnectionClassName);
            Constructor<XAConnection> constructor = XAUtils.getConstructorByDBType(xaConnectionClass, dbType);
            if (constructor == null) {
                throw new SQLException("xa not support dbType: " + dbType);
            }
            constructor.setAccessible(true);
            List<Object> params = XAUtils.getInitargsByDBType(dbType, physicalConnection);
            return constructor.newInstance(params.toArray(new Object[0]));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create XA Connection " + xaConnectionClassName + " on " + physicalConnection);
            if (e instanceof XAException) {
                throw (XAException)e;
            }
            throw new SQLException(e);
        }
    }

    private static Constructor<XAConnection> getConstructorByDBType(Class xaConnectionClass, String dbType) throws SQLException {
        try {
            switch (dbType) {
                case "oracle": {
                    return xaConnectionClass.getConstructor(Connection.class);
                }
                case "mariadb": {
                    Class<?> mariaXaConnectionClass = Class.forName("org.mariadb.jdbc.MariaDbConnection");
                    return xaConnectionClass.getConstructor(mariaXaConnectionClass);
                }
            }
            throw new SQLException("xa reflect not support dbType: " + dbType);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private static <T> List<T> getInitargsByDBType(String dbType, Object ... params) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (params.length == 0) {
            return null;
        }
        if (!(params[0] instanceof Connection)) {
            throw new SQLException("not support params: " + Arrays.toString(params));
        }
        try {
            switch (dbType) {
                case "oracle": {
                    result.add(params[0]);
                    return result;
                }
                case "mariadb": {
                    Class<?> mariaDbConnectionClass = Class.forName("org.mariadb.jdbc.MariaDbConnection");
                    if (!mariaDbConnectionClass.isInstance(params[0])) break;
                    Object mariaDbConnectionInstance = mariaDbConnectionClass.cast(params[0]);
                    result.add(mariaDbConnectionInstance);
                    return result;
                }
            }
            throw new SQLException("xa reflect not support dbType: " + dbType);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }
}

