/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.saga.engine.pcext.InterceptableStateHandler;
import org.apache.seata.saga.engine.pcext.StateHandler;
import org.apache.seata.saga.engine.pcext.StateHandlerInterceptor;
import org.apache.seata.saga.engine.pcext.StateInstruction;
import org.apache.seata.saga.engine.pcext.handlers.ChoiceStateHandler;
import org.apache.seata.saga.engine.pcext.handlers.CompensationTriggerStateHandler;
import org.apache.seata.saga.engine.pcext.handlers.FailEndStateHandler;
import org.apache.seata.saga.engine.pcext.handlers.LoopStartStateHandler;
import org.apache.seata.saga.engine.pcext.handlers.ScriptTaskStateHandler;
import org.apache.seata.saga.engine.pcext.handlers.ServiceTaskStateHandler;
import org.apache.seata.saga.engine.pcext.handlers.SubStateMachineHandler;
import org.apache.seata.saga.engine.pcext.handlers.SucceedEndStateHandler;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.proctrl.handler.ProcessHandler;
import org.apache.seata.saga.statelang.domain.State;

public class StateMachineProcessHandler
implements ProcessHandler {
    private final Map<String, StateHandler> stateHandlers = new ConcurrentHashMap<String, StateHandler>();

    @Override
    public void process(ProcessContext context) throws FrameworkException {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        State state = instruction.getState(context);
        String stateType = state.getType();
        StateHandler stateHandler = this.stateHandlers.get(stateType);
        List<StateHandlerInterceptor> interceptors = null;
        if (stateHandler instanceof InterceptableStateHandler) {
            interceptors = ((InterceptableStateHandler)stateHandler).getInterceptors();
        }
        ArrayList<StateHandlerInterceptor> executedInterceptors = null;
        Exception exception = null;
        try {
            if (CollectionUtils.isNotEmpty(interceptors)) {
                executedInterceptors = new ArrayList<StateHandlerInterceptor>(interceptors.size());
                for (StateHandlerInterceptor interceptor : interceptors) {
                    executedInterceptors.add(interceptor);
                    interceptor.preProcess(context);
                }
            }
            stateHandler.process(context);
        }
        catch (Exception e) {
            exception = e;
            throw e;
        }
        finally {
            if (CollectionUtils.isNotEmpty(executedInterceptors)) {
                for (int i = executedInterceptors.size() - 1; i >= 0; --i) {
                    StateHandlerInterceptor interceptor = (StateHandlerInterceptor)executedInterceptors.get(i);
                    interceptor.postProcess(context, exception);
                }
            }
        }
    }

    public void initDefaultHandlers() {
        if (this.stateHandlers.isEmpty()) {
            this.stateHandlers.put("ServiceTask", new ServiceTaskStateHandler());
            this.stateHandlers.put("ScriptTask", new ScriptTaskStateHandler());
            this.stateHandlers.put("CompensateSubMachine", new ServiceTaskStateHandler());
            this.stateHandlers.put("SubStateMachine", new SubStateMachineHandler());
            this.stateHandlers.put("Choice", new ChoiceStateHandler());
            this.stateHandlers.put("Succeed", new SucceedEndStateHandler());
            this.stateHandlers.put("Fail", new FailEndStateHandler());
            this.stateHandlers.put("CompensationTrigger", new CompensationTriggerStateHandler());
            this.stateHandlers.put("LoopStart", new LoopStartStateHandler());
        }
    }

    public Map<String, StateHandler> getStateHandlers() {
        return this.stateHandlers;
    }

    public void setStateHandlers(Map<String, StateHandler> stateHandlers) {
        this.stateHandlers.putAll(stateHandlers);
    }
}

