/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.statelang.validator.impl;

import java.util.Set;
import org.apache.seata.saga.statelang.domain.State;
import org.apache.seata.saga.statelang.domain.StateMachine;
import org.apache.seata.saga.statelang.parser.utils.StateMachineUtils;
import org.apache.seata.saga.statelang.validator.impl.AbstractRule;

public class StateNameExistsRule
extends AbstractRule {
    @Override
    public boolean validate(StateMachine stateMachine) {
        for (State state : stateMachine.getStates().values()) {
            Set<String> subsequentStates = StateMachineUtils.getAllPossibleSubsequentStates(state);
            for (String subsequentState : subsequentStates) {
                if (stateMachine.getState(subsequentState) != null) continue;
                this.hint = String.format("Subsequent state [%s] of [%s] does not exist", subsequentState, state);
                return false;
            }
        }
        return true;
    }
}

