/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.sqlparser.druid.sqlserver;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.sqlparser.ParametersHolder;
import org.apache.seata.sqlparser.SQLType;
import org.apache.seata.sqlparser.SQLUpdateRecognizer;
import org.apache.seata.sqlparser.druid.sqlserver.BaseSqlServerRecognizer;
import org.apache.seata.sqlparser.struct.Null;
import org.apache.seata.sqlparser.struct.SqlDefaultExpr;
import org.apache.seata.sqlparser.struct.SqlMethodExpr;
import org.apache.seata.sqlparser.struct.SqlSequenceExpr;
import org.apache.seata.sqlparser.util.ColumnUtils;

public class SqlServerUpdateRecognizer
extends BaseSqlServerRecognizer
implements SQLUpdateRecognizer {
    private SQLServerUpdateStatement ast;

    public SqlServerUpdateRecognizer(String originalSql, SQLStatement ast) {
        super(originalSql);
        this.ast = (SQLServerUpdateStatement)ast;
    }

    @Override
    public SQLType getSQLType() {
        return SQLType.UPDATE;
    }

    @Override
    public String getTableAlias() {
        return this.ast.getTableSource().getAlias();
    }

    @Override
    public String getTableName() {
        StringBuilder sb = new StringBuilder();
        SQLServerOutputVisitor visitor = new SQLServerOutputVisitor(sb){

            public boolean visit(SQLExprTableSource x) {
                this.printTableSourceExpr(x.getExpr());
                return false;
            }

            public boolean visit(SQLJoinTableSource x) {
                throw new NotSupportYetException("not support the syntax of update with join table");
            }
        };
        SQLTableSource tableSource = this.ast.getTableSource();
        if (tableSource instanceof SQLExprTableSource) {
            visitor.visit((SQLExprTableSource)tableSource);
        } else if (tableSource instanceof SQLJoinTableSource) {
            visitor.visit((SQLJoinTableSource)tableSource);
        } else {
            throw new NotSupportYetException("not support the syntax of update with unknow");
        }
        return sb.toString();
    }

    @Override
    public List<String> getUpdateColumns() {
        List updateSetItems = this.ast.getItems();
        ArrayList<String> list = new ArrayList<String>(updateSetItems.size());
        for (SQLUpdateSetItem updateSetItem : updateSetItems) {
            SQLExpr expr = updateSetItem.getColumn();
            if (expr instanceof SQLIdentifierExpr) {
                list.add(((SQLIdentifierExpr)expr).getName());
                continue;
            }
            if (expr instanceof SQLPropertyExpr) {
                SQLExpr owner = ((SQLPropertyExpr)expr).getOwner();
                if (owner instanceof SQLIdentifierExpr) {
                    list.add(((SQLIdentifierExpr)owner).getName() + "." + ((SQLPropertyExpr)expr).getName());
                    continue;
                }
                if (((SQLPropertyExpr)expr).getOwnerName().split("\\.").length <= 1) continue;
                list.add(((SQLPropertyExpr)expr).getOwnerName() + "." + ((SQLPropertyExpr)expr).getName());
                continue;
            }
            this.wrapSQLParsingException(expr);
        }
        return list;
    }

    @Override
    public List<Object> getUpdateValues() {
        if (this.ast.getTop() != null) {
            this.dealTop((SQLStatement)this.ast);
        }
        List updateSetItems = this.ast.getItems();
        ArrayList<Object> list = new ArrayList<Object>(updateSetItems.size());
        for (SQLUpdateSetItem updateSetItem : updateSetItems) {
            SQLExpr expr = updateSetItem.getValue();
            if (expr instanceof SQLNullExpr) {
                list.add(Null.get());
                continue;
            }
            if (expr instanceof SQLValuableExpr) {
                list.add(((SQLValuableExpr)expr).getValue());
                continue;
            }
            if (expr instanceof SQLVariantRefExpr) {
                list.add(((SQLVariantRefExpr)expr).getName());
                continue;
            }
            if (expr instanceof SQLMethodInvokeExpr) {
                list.add(SqlMethodExpr.get());
                continue;
            }
            if (expr instanceof SQLDefaultExpr) {
                list.add(SqlDefaultExpr.get());
                continue;
            }
            if (expr instanceof SQLSequenceExpr) {
                SQLSequenceExpr sequenceExpr = (SQLSequenceExpr)expr;
                String sequence = sequenceExpr.getSequence().getSimpleName();
                String function = sequenceExpr.getFunction().name;
                list.add(new SqlSequenceExpr(sequence, function));
                continue;
            }
            this.wrapSQLParsingException(expr);
        }
        return list;
    }

    @Override
    public String getTableAlias(String tableName) {
        return SQLUpdateRecognizer.super.getTableAlias(tableName);
    }

    @Override
    public List<String> getUpdateColumnsUnEscape() {
        List<String> updateColumns = this.getUpdateColumns();
        return ColumnUtils.delEscape(updateColumns, this.getDbType());
    }

    @Override
    public String getWhereCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        SQLExpr where = this.ast.getWhere();
        return super.getWhereCondition(where, parametersHolder, paramAppenderList);
    }

    @Override
    public String getWhereCondition() {
        SQLExpr where = this.ast.getWhere();
        return super.getWhereCondition(where);
    }

    @Override
    public String getLimitCondition() {
        return null;
    }

    @Override
    public String getLimitCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        return null;
    }

    @Override
    public String getOrderByCondition() {
        return null;
    }

    @Override
    public String getOrderByCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        return null;
    }

    @Override
    protected SQLStatement getAst() {
        return this.ast;
    }
}

