/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.common.metadata.datasource;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.spi.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.spi.database.metadata.MemorizedDataSourceMetaData;
import org.apache.shardingsphere.spi.database.type.DatabaseType;
import org.apache.shardingsphere.underlying.common.config.DatabaseAccessConfiguration;

public final class DataSourceMetas {
    private final Map<String, DataSourceMetaData> dataSourceMetaDataMap;

    public DataSourceMetas(DatabaseType databaseType, Map<String, DatabaseAccessConfiguration> databaseAccessConfigurationMap) {
        this.dataSourceMetaDataMap = this.getDataSourceMetaDataMap(databaseType, databaseAccessConfigurationMap);
    }

    private Map<String, DataSourceMetaData> getDataSourceMetaDataMap(DatabaseType databaseType, Map<String, DatabaseAccessConfiguration> databaseAccessConfigurationMap) {
        return databaseAccessConfigurationMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> databaseType.getDataSourceMetaData(((DatabaseAccessConfiguration)entry.getValue()).getUrl(), ((DatabaseAccessConfiguration)entry.getValue()).getUsername())));
    }

    public Collection<String> getAllInstanceDataSourceNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, DataSourceMetaData> entry : this.dataSourceMetaDataMap.entrySet()) {
            if (this.isExisted(entry.getKey(), result)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private boolean isExisted(String dataSourceName, Collection<String> existedDataSourceNames) {
        return existedDataSourceNames.stream().anyMatch(each -> this.isInSameDatabaseInstance(this.dataSourceMetaDataMap.get(dataSourceName), this.dataSourceMetaDataMap.get(each)));
    }

    private boolean isInSameDatabaseInstance(DataSourceMetaData sample, DataSourceMetaData target) {
        return sample instanceof MemorizedDataSourceMetaData ? Objects.equals(target.getSchema(), sample.getSchema()) : target.getHostName().equals(sample.getHostName()) && target.getPort() == sample.getPort();
    }

    public DataSourceMetaData getDataSourceMetaData(String dataSourceName) {
        return this.dataSourceMetaDataMap.get(dataSourceName);
    }
}

