/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.common.database.metadata.dialect;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.spi.database.metadata.MemorizedDataSourceMetaData;
import org.apache.shardingsphere.underlying.common.database.metadata.UnrecognizedDatabaseURLException;

public final class H2DataSourceMetaData
implements MemorizedDataSourceMetaData {
    private static final int DEFAULT_PORT = -1;
    private final String hostName;
    private final int port;
    private final String catalog;
    private final String schema;
    private final Pattern pattern = Pattern.compile("jdbc:h2:(mem|~)[:/]([\\w\\-]+);?\\S*", 2);

    public H2DataSourceMetaData(String url) {
        Matcher matcher = this.pattern.matcher(url);
        if (!matcher.find()) {
            throw new UnrecognizedDatabaseURLException(url, this.pattern.pattern());
        }
        this.hostName = "";
        this.port = -1;
        this.catalog = matcher.group(2);
        this.schema = null;
    }

    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }
}

