/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.datanode;

import com.google.common.base.Splitter;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.shardingsphere.infra.datanode.DataNode;

public final class JobDataNodeEntry {
    @NonNull
    private final String logicTableName;
    @NonNull
    private final List<DataNode> dataNodes;

    public static JobDataNodeEntry unmarshal(String text) {
        List segments = Splitter.on((String)":").splitToList((CharSequence)text);
        String logicTableName = (String)segments.get(0);
        LinkedList<DataNode> dataNodes = new LinkedList<DataNode>();
        for (String each : Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)segments.get(1))) {
            dataNodes.add(new DataNode(each));
        }
        return new JobDataNodeEntry(logicTableName, dataNodes);
    }

    public String marshal() {
        StringBuilder result = new StringBuilder(this.getMarshalledTextEstimatedLength());
        result.append(this.logicTableName);
        result.append(":");
        for (DataNode each : this.dataNodes) {
            result.append(each.format()).append(',');
        }
        if (!this.dataNodes.isEmpty()) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public int getMarshalledTextEstimatedLength() {
        return this.logicTableName.length() + 1 + this.dataNodes.stream().mapToInt(DataNode::getFormattedTextLength).sum() + this.dataNodes.size();
    }

    @NonNull
    @Generated
    public String getLogicTableName() {
        return this.logicTableName;
    }

    @NonNull
    @Generated
    public List<DataNode> getDataNodes() {
        return this.dataNodes;
    }

    @Generated
    public JobDataNodeEntry(@NonNull String logicTableName, @NonNull List<DataNode> dataNodes) {
        if (logicTableName == null) {
            throw new NullPointerException("logicTableName is marked non-null but is null");
        }
        if (dataNodes == null) {
            throw new NullPointerException("dataNodes is marked non-null but is null");
        }
        this.logicTableName = logicTableName;
        this.dataNodes = dataNodes;
    }

    @Generated
    public String toString() {
        return "JobDataNodeEntry(logicTableName=" + this.getLogicTableName() + ", dataNodes=" + this.getDataNodes() + ")";
    }
}

