/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.job;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public enum JobType {
    MIGRATION("MIGRATION", "01"),
    CONSISTENCY_CHECK("CONSISTENCY_CHECK", "02");

    private static final Map<String, JobType> CODE_JOB_TYPE_MAP;
    private final String typeName;
    private final String lowercaseTypeName;
    private final String typeCode;

    private JobType(String typeName, String typeCode) {
        this.typeName = typeName;
        this.lowercaseTypeName = typeName.toLowerCase();
        Preconditions.checkArgument((2 == typeCode.length() ? 1 : 0) != 0, (Object)"code length is not 2");
        this.typeCode = typeCode;
    }

    public static JobType valueOfByCode(String typeCode) {
        return CODE_JOB_TYPE_MAP.get(typeCode);
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getLowercaseTypeName() {
        return this.lowercaseTypeName;
    }

    @Generated
    public String getTypeCode() {
        return this.typeCode;
    }

    static {
        CODE_JOB_TYPE_MAP = Arrays.stream(JobType.values()).collect(Collectors.toMap(JobType::getTypeCode, each -> each));
    }
}

