/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.datasource.config;

import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.generic.UnsupportedSQLOperationException;

public final class PipelineDataSourceConfigurationFactory {
    public static PipelineDataSourceConfiguration newInstance(String type, String param) {
        switch (type) {
            case "JDBC": {
                return new StandardPipelineDataSourceConfiguration(param);
            }
            case "ShardingSphereJDBC": {
                return new ShardingSpherePipelineDataSourceConfiguration(param);
            }
        }
        throw new UnsupportedSQLOperationException(String.format("Unsupported data source type `%s`", type));
    }

    @Generated
    private PipelineDataSourceConfigurationFactory() {
    }
}

