/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.spring.boot;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.algorithm.config.AlgorithmProvidedDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryProviderAlgorithm;
import org.apache.shardingsphere.dbdiscovery.spring.boot.algorithm.DatabaseDiscoveryAlgorithmProvidedBeanRegistry;
import org.apache.shardingsphere.dbdiscovery.spring.boot.condition.DatabaseDiscoverySpringBootCondition;
import org.apache.shardingsphere.dbdiscovery.spring.boot.rule.YamlDatabaseDiscoveryRuleSpringBootConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.YamlDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.swapper.YamlDatabaseDiscoveryRuleAlgorithmProviderConfigurationSwapper;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={YamlDatabaseDiscoveryRuleSpringBootConfiguration.class})
@ConditionalOnClass(value={YamlDatabaseDiscoveryRuleConfiguration.class})
@Conditional(value={DatabaseDiscoverySpringBootCondition.class})
public class DatabaseDiscoveryRuleSpringbootConfiguration {
    private final YamlDatabaseDiscoveryRuleAlgorithmProviderConfigurationSwapper swapper = new YamlDatabaseDiscoveryRuleAlgorithmProviderConfigurationSwapper();
    private final YamlDatabaseDiscoveryRuleSpringBootConfiguration yamlConfig;

    @Bean
    public RuleConfiguration discoveryRuleConfiguration(ObjectProvider<Map<String, DatabaseDiscoveryProviderAlgorithm>> discoveryTypes) {
        AlgorithmProvidedDatabaseDiscoveryRuleConfiguration result = this.swapper.swapToObject(this.yamlConfig.getDatabaseDiscovery());
        Map discoveryTypeMap = Optional.ofNullable(discoveryTypes.getIfAvailable()).orElseGet(Collections::emptyMap);
        result.setDiscoveryTypes(discoveryTypeMap);
        return result;
    }

    @Bean
    public static DatabaseDiscoveryAlgorithmProvidedBeanRegistry databaseDiscoveryAlgorithmProvidedBeanRegistry(Environment environment) {
        return new DatabaseDiscoveryAlgorithmProvidedBeanRegistry(environment);
    }

    @Generated
    public DatabaseDiscoveryRuleSpringbootConfiguration(YamlDatabaseDiscoveryRuleSpringBootConfiguration yamlConfig) {
        this.yamlConfig = yamlConfig;
    }
}

