/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.executor.log;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.executor.context.ExecutionUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ShardingSphere-SQL");

    public static void logSQL(String logicSQL, boolean showSimple, SQLStatementContext sqlStatementContext, Collection<ExecutionUnit> executionUnits) {
        SQLLogger.log("Logic SQL: {}", logicSQL);
        SQLLogger.log("SQLStatement: {}", sqlStatementContext);
        if (showSimple) {
            SQLLogger.logSimpleMode(executionUnits);
        } else {
            SQLLogger.logNormalMode(executionUnits);
        }
    }

    private static void logSimpleMode(Collection<ExecutionUnit> executionUnits) {
        HashSet<String> dataSourceNames = new HashSet<String>(executionUnits.size());
        for (ExecutionUnit each : executionUnits) {
            dataSourceNames.add(each.getDataSourceName());
        }
        SQLLogger.log("Actual SQL(simple): {} ::: {}", dataSourceNames, executionUnits.size());
    }

    private static void logNormalMode(Collection<ExecutionUnit> executionUnits) {
        for (ExecutionUnit each : executionUnits) {
            if (each.getSqlUnit().getParameters().isEmpty()) {
                SQLLogger.log("Actual SQL: {} ::: {}", each.getDataSourceName(), each.getSqlUnit().getSql());
                continue;
            }
            SQLLogger.log("Actual SQL: {} ::: {} ::: {}", each.getDataSourceName(), each.getSqlUnit().getSql(), each.getSqlUnit().getParameters());
        }
    }

    private static void log(String pattern, Object ... arguments) {
        log.info(pattern, arguments);
    }

    @Generated
    private SQLLogger() {
    }
}

