/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterViewStatementHandler;

public final class AlterViewStatementContext
extends CommonSQLStatementContext<AlterViewStatement>
implements TableAvailable {
    private final TablesContext tablesContext;

    public AlterViewStatementContext(AlterViewStatement sqlStatement) {
        super(sqlStatement);
        LinkedList<SimpleTableSegment> tables = new LinkedList<SimpleTableSegment>();
        tables.add(sqlStatement.getView());
        Optional selectStatement = AlterViewStatementHandler.getSelectStatement((AlterViewStatement)sqlStatement);
        selectStatement.ifPresent(optional -> {
            TableExtractor extractor = new TableExtractor();
            extractor.extractTablesFromSelect(optional);
            tables.addAll(extractor.getRewriteTables());
        });
        AlterViewStatementHandler.getRenameView((AlterViewStatement)sqlStatement).ifPresent(tables::add);
        this.tablesContext = new TablesContext(tables, this.getDatabaseType());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getTables();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

