/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.insert.values;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtils;

public final class OnDuplicateUpdateContext {
    private final int parameterCount;
    private final List<ExpressionSegment> valueExpressions;
    private final List<ParameterMarkerExpressionSegment> parameterMarkerExpressions;
    private final List<Object> parameters;
    private final List<ColumnSegment> columns;

    public OnDuplicateUpdateContext(Collection<AssignmentSegment> assignments, List<Object> params, int parametersOffset) {
        List<ExpressionSegment> expressionSegments = assignments.stream().map(AssignmentSegment::getValue).collect(Collectors.toList());
        this.valueExpressions = this.getValueExpressions(expressionSegments);
        this.parameterMarkerExpressions = ExpressionExtractUtils.getParameterMarkerExpressions(expressionSegments);
        this.parameterCount = this.parameterMarkerExpressions.size();
        this.parameters = this.getParameters(params, parametersOffset);
        this.columns = assignments.stream().map(each -> (ColumnSegment)each.getColumns().get(0)).collect(Collectors.toList());
    }

    private List<ExpressionSegment> getValueExpressions(Collection<ExpressionSegment> assignments) {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(assignments.size());
        result.addAll(assignments);
        return result;
    }

    private List<Object> getParameters(List<Object> params, int paramsOffset) {
        if (params.isEmpty() || 0 == this.parameterCount) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.parameterCount);
        result.addAll(params.subList(paramsOffset, paramsOffset + this.parameterCount));
        return result;
    }

    public Object getValue(int index) {
        ExpressionSegment valueExpression = this.valueExpressions.get(index);
        if (valueExpression instanceof ParameterMarkerExpressionSegment) {
            return this.parameters.get(this.getParameterIndex((ParameterMarkerExpressionSegment)valueExpression));
        }
        if (valueExpression instanceof FunctionSegment) {
            return valueExpression;
        }
        return ((LiteralExpressionSegment)valueExpression).getLiterals();
    }

    private int getParameterIndex(ParameterMarkerExpressionSegment paramMarkerExpression) {
        int result = this.parameterMarkerExpressions.indexOf(paramMarkerExpression);
        Preconditions.checkArgument((result >= 0 ? 1 : 0) != 0, (Object)"Can not get parameter index.");
        return result;
    }

    public ColumnSegment getColumn(int index) {
        return this.columns.get(index);
    }

    @Generated
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Generated
    public List<ExpressionSegment> getValueExpressions() {
        return this.valueExpressions;
    }

    @Generated
    public List<ParameterMarkerExpressionSegment> getParameterMarkerExpressions() {
        return this.parameterMarkerExpressions;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public List<ColumnSegment> getColumns() {
        return this.columns;
    }

    @Generated
    public String toString() {
        return "OnDuplicateUpdateContext(parameterCount=" + this.getParameterCount() + ", valueExpressions=" + this.getValueExpressions() + ", parameterMarkerExpressions=" + this.getParameterMarkerExpressions() + ", parameters=" + this.getParameters() + ", columns=" + this.getColumns() + ")";
    }
}

