/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.RenameTableStatement;

public final class RenameTableStatementContext
extends CommonSQLStatementContext
implements TableAvailable {
    private final TablesContext tablesContext;

    public RenameTableStatementContext(RenameTableStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getRenameTables().stream().map(RenameTableDefinitionSegment::getRenameTable).collect(Collectors.toList()), this.getDatabaseType());
    }

    public RenameTableStatement getSqlStatement() {
        return (RenameTableStatement)super.getSqlStatement();
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (RenameTableDefinitionSegment each : this.getSqlStatement().getRenameTables()) {
            result.add(each.getTable());
            result.add(each.getRenameTable());
        }
        return result;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

