/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.from;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;

public final class SimpleTableSegmentBinderContext
implements TableSegmentBinderContext {
    private final Map<String, ProjectionSegment> columnLabelProjectionSegments;

    public SimpleTableSegmentBinderContext(Collection<ProjectionSegment> projectionSegments) {
        this.columnLabelProjectionSegments = new LinkedHashMap<String, ProjectionSegment>(projectionSegments.size(), 1.0f);
        projectionSegments.forEach(each -> this.putColumnLabelProjectionSegments((ProjectionSegment)each, this.columnLabelProjectionSegments));
    }

    private void putColumnLabelProjectionSegments(ProjectionSegment projectionSegment, Map<String, ProjectionSegment> columnLabelProjectionSegments) {
        if (projectionSegment instanceof ShorthandProjectionSegment) {
            ((ShorthandProjectionSegment)projectionSegment).getActualProjectionSegments().forEach(each -> columnLabelProjectionSegments.put(each.getColumnLabel().toLowerCase(), (ProjectionSegment)each));
        } else {
            columnLabelProjectionSegments.put(projectionSegment.getColumnLabel().toLowerCase(), projectionSegment);
        }
    }

    @Override
    public Optional<ProjectionSegment> findProjectionSegmentByColumnLabel(String columnLabel) {
        return Optional.ofNullable(this.columnLabelProjectionSegments.get(columnLabel.toLowerCase()));
    }

    @Override
    public Collection<ProjectionSegment> getProjectionSegments() {
        return this.columnLabelProjectionSegments.values();
    }

    @Generated
    public SimpleTableSegmentBinderContext(Map<String, ProjectionSegment> columnLabelProjectionSegments) {
        this.columnLabelProjectionSegments = columnLabelProjectionSegments;
    }
}

