/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.projection;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.projection.impl.ColumnProjectionSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.projection.impl.ShorthandProjectionSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.projection.impl.SubqueryProjectionSegmentBinder;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;

public final class ProjectionsSegmentBinder {
    public static ProjectionsSegment bind(ProjectionsSegment segment, SQLStatementBinderContext statementBinderContext, TableSegment boundedTableSegment, Map<String, TableSegmentBinderContext> tableBinderContexts, Map<String, TableSegmentBinderContext> outerTableBinderContexts) {
        ProjectionsSegment result = new ProjectionsSegment(segment.getStartIndex(), segment.getStopIndex());
        result.setDistinctRow(segment.isDistinctRow());
        segment.getProjections().forEach(each -> result.getProjections().add(ProjectionsSegmentBinder.bind(each, statementBinderContext, boundedTableSegment, tableBinderContexts, outerTableBinderContexts)));
        return result;
    }

    private static ProjectionSegment bind(ProjectionSegment projectionSegment, SQLStatementBinderContext statementBinderContext, TableSegment boundedTableSegment, Map<String, TableSegmentBinderContext> tableBinderContexts, Map<String, TableSegmentBinderContext> outerTableBinderContexts) {
        if (projectionSegment instanceof ColumnProjectionSegment) {
            return ColumnProjectionSegmentBinder.bind((ColumnProjectionSegment)projectionSegment, statementBinderContext, tableBinderContexts);
        }
        if (projectionSegment instanceof ShorthandProjectionSegment) {
            return ShorthandProjectionSegmentBinder.bind((ShorthandProjectionSegment)projectionSegment, boundedTableSegment, tableBinderContexts);
        }
        if (projectionSegment instanceof SubqueryProjectionSegment) {
            LinkedHashMap<String, TableSegmentBinderContext> newOuterTableBinderContexts = new LinkedHashMap<String, TableSegmentBinderContext>();
            newOuterTableBinderContexts.putAll(outerTableBinderContexts);
            newOuterTableBinderContexts.putAll(tableBinderContexts);
            return SubqueryProjectionSegmentBinder.bind((SubqueryProjectionSegment)projectionSegment, statementBinderContext, newOuterTableBinderContexts);
        }
        return projectionSegment;
    }

    @Generated
    private ProjectionsSegmentBinder() {
    }
}

