/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.dialect;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.url.JdbcUrl;
import org.apache.shardingsphere.infra.database.metadata.url.StandardJdbcUrlParser;

public final class PostgreSQLDataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = 5432;
    private final String hostname;
    private final int port;
    private final String catalog;
    private final String schema;
    private final Properties queryProperties;

    public PostgreSQLDataSourceMetaData(String url) {
        JdbcUrl jdbcUrl = new StandardJdbcUrlParser().parse(url);
        this.hostname = jdbcUrl.getHostname();
        this.port = -1 == jdbcUrl.getPort() ? 5432 : jdbcUrl.getPort();
        this.catalog = jdbcUrl.getDatabase();
        this.schema = null;
        this.queryProperties = jdbcUrl.getQueryProperties();
    }

    @Override
    public Properties getDefaultQueryProperties() {
        return new Properties();
    }

    @Override
    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Generated
    public Properties getQueryProperties() {
        return this.queryProperties;
    }
}

