/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.datasource.registry.GlobalDataSourceRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.exception.UnsupportedActualDataNodeStructureException;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.SchemaMetaDataLoaderMaterials;

public class SchemaMetaDataUtil {
    public static Collection<SchemaMetaDataLoaderMaterials> getSchemaMetaDataLoaderMaterials(Collection<String> tableNames, GenericSchemaBuilderMaterials materials, boolean checkMetaDataEnable) {
        LinkedHashMap<String, Collection<String>> dataSourceTableGroups = new LinkedHashMap<String, Collection<String>>();
        DataNodes dataNodes = new DataNodes(materials.getRules());
        for (String each : tableNames) {
            SchemaMetaDataUtil.checkDataSourceTypeIncludeInstanceAndSetDatabaseTableMap(materials.getStorageType(), dataNodes, each);
            if (checkMetaDataEnable) {
                SchemaMetaDataUtil.addAllActualTableDataNode(materials, dataSourceTableGroups, dataNodes, each);
                continue;
            }
            SchemaMetaDataUtil.addOneActualTableDataNode(materials, dataSourceTableGroups, dataNodes, each);
        }
        return dataSourceTableGroups.entrySet().stream().map(entry -> new SchemaMetaDataLoaderMaterials((Collection)entry.getValue(), materials.getDataSourceMap().get(((String)entry.getKey()).contains(".") ? ((String)entry.getKey()).split("\\.")[0] : entry.getKey()), materials.getDefaultSchemaName())).collect(Collectors.toList());
    }

    private static void checkDataSourceTypeIncludeInstanceAndSetDatabaseTableMap(DatabaseType databaseType, DataNodes dataNodes, String tableName) {
        for (DataNode dataNode : dataNodes.getDataNodes(tableName)) {
            if (null != databaseType.getType() && !"MySQL".equals(databaseType.getType()) && dataNode.getDataSourceName().contains(".")) {
                throw new UnsupportedActualDataNodeStructureException(dataNode, databaseType.getJdbcUrlPrefixes());
            }
            if (!dataNode.getDataSourceName().contains(".")) continue;
            String database = dataNode.getDataSourceName().split("\\.")[1];
            GlobalDataSourceRegistry.getInstance().getCachedDatabaseTables().put(dataNode.getTableName(), database);
        }
    }

    private static void addOneActualTableDataNode(GenericSchemaBuilderMaterials materials, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Optional<DataNode> dataNode = dataNodes.getDataNodes(table).stream().filter(each -> SchemaMetaDataUtil.isSameDataSourceNameSchemaName(materials, each)).findFirst();
        String dataSourceName = dataNode.map(DataNode::getDataSourceName).orElseGet(() -> materials.getDataSourceMap().keySet().iterator().next());
        String tableName = dataNode.map(DataNode::getTableName).orElse(table);
        SchemaMetaDataUtil.addDataSourceTableGroups(dataSourceName, tableName, dataSourceTableGroups);
    }

    private static boolean isSameDataSourceNameSchemaName(GenericSchemaBuilderMaterials materials, DataNode dataNode) {
        String dataSourceName;
        String string = dataSourceName = dataNode.getDataSourceName().contains(".") ? dataNode.getDataSourceName().split("\\.")[0] : dataNode.getDataSourceName();
        if (!materials.getDataSourceMap().containsKey(dataSourceName)) {
            return false;
        }
        return null == dataNode.getSchemaName() || dataNode.getSchemaName().equalsIgnoreCase(materials.getDefaultSchemaName());
    }

    private static void addAllActualTableDataNode(GenericSchemaBuilderMaterials materials, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Collection<DataNode> tableDataNodes = dataNodes.getDataNodes(table);
        if (tableDataNodes.isEmpty()) {
            SchemaMetaDataUtil.addDataSourceTableGroups(materials.getDataSourceMap().keySet().iterator().next(), table, dataSourceTableGroups);
        } else {
            tableDataNodes.forEach(each -> SchemaMetaDataUtil.addDataSourceTableGroups(each.getDataSourceName(), each.getTableName(), dataSourceTableGroups));
        }
    }

    private static void addDataSourceTableGroups(String dataSourceName, String tableName, Map<String, Collection<String>> dataSourceTableGroups) {
        Collection tables = dataSourceTableGroups.getOrDefault(dataSourceName, new LinkedList());
        tables.add(tableName);
        dataSourceTableGroups.putIfAbsent(dataSourceName, tables);
    }

    @Generated
    private SchemaMetaDataUtil() {
    }
}

