/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapper;

public final class StorageResourceUtils {
    public static Map<StorageNode, DataSource> getStorageNodeDataSources(Map<String, DataSource> dataSources) {
        return dataSources.entrySet().stream().collect(Collectors.toMap(entry -> new StorageNode((String)entry.getKey()), Map.Entry::getValue, (oldValue, currentValue) -> currentValue, () -> new LinkedHashMap(dataSources.size(), 1.0f)));
    }

    public static Map<String, StorageUnitNodeMapper> getStorageUnitNodeMappers(Map<String, DataSource> dataSources) {
        return dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StorageResourceUtils.getStorageUnitNodeMapper((String)entry.getKey(), (DataSource)entry.getValue()), (oldValue, currentValue) -> currentValue, LinkedHashMap::new));
    }

    public static StorageUnitNodeMapper getStorageUnitNodeMapper(String dataSourceName, DataSource dataSource) {
        DataSourcePoolProperties props = DataSourcePoolPropertiesCreator.create((DataSource)dataSource);
        String url = props.getConnectionPropertySynonyms().getStandardProperties().get("url").toString();
        return new StorageUnitNodeMapper(dataSourceName, new StorageNode(dataSourceName), url);
    }

    @Generated
    private StorageResourceUtils() {
    }
}

