/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.RenameTableStatement;

public final class RenameTableStatementSchemaRefresher
implements MetaDataRefresher<RenameTableStatement> {
    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, RenameTableStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        SchemaAlteredEvent event = new SchemaAlteredEvent(database.getName(), schemaName);
        for (RenameTableDefinitionSegment each : sqlStatement.getRenameTables()) {
            String tableName = each.getTable().getTableName().getIdentifier().getValue();
            String renameTable = each.getRenameTable().getTableName().getIdentifier().getValue();
            this.putTableMetaData(database, logicDataSourceNames, schemaName, renameTable, props);
            this.removeTableMetaData(database, schemaName, tableName);
            event.getAlteredTables().add(database.getSchema(schemaName).get(renameTable));
            event.getDroppedTables().add(tableName);
        }
        return Optional.of(event);
    }

    private void removeTableMetaData(ShardingSphereDatabase database, String schemaName, String tableName) {
        database.getSchema(schemaName).remove(tableName);
        database.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.remove(schemaName, tableName));
    }

    private void putTableMetaData(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, String tableName, ConfigurationProperties props) throws SQLException {
        if (!this.containsInImmutableDataNodeContainedRule(tableName, database)) {
            database.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.put((String)logicDataSourceNames.iterator().next(), schemaName, tableName));
        }
        GenericSchemaBuilderMaterials materials = new GenericSchemaBuilderMaterials(database.getProtocolType(), database.getResource().getDatabaseType(), database.getResource().getDataSources(), database.getRuleMetaData().getRules(), props, schemaName);
        Map schemaMap = GenericSchemaBuilder.build(Collections.singletonList(tableName), (GenericSchemaBuilderMaterials)materials);
        Optional<ShardingSphereTable> actualTableMetaData = Optional.ofNullable(schemaMap.get(schemaName)).map(optional -> optional.get(tableName));
        actualTableMetaData.ifPresent(optional -> database.getSchema(schemaName).put(tableName, optional));
    }

    private boolean containsInImmutableDataNodeContainedRule(String tableName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().filter(each -> !(each instanceof MutableDataNodeRule)).anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public String getType() {
        return RenameTableStatement.class.getName();
    }
}

