/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.event.DropSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class DropSchemaStatementSchemaRefresher
implements MetaDataRefresher<DropSchemaStatement> {
    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DropSchemaStatement sqlStatement, ConfigurationProperties props) {
        LinkedHashSet tobeRemovedTables = new LinkedHashSet();
        LinkedHashSet<String> tobeRemovedSchemas = new LinkedHashSet<String>();
        Collection<String> schemaNames = this.getSchemaNames(sqlStatement);
        for (String each : schemaNames) {
            ShardingSphereSchema schema = new ShardingSphereSchema(database.getSchema(schemaName).getTables(), database.getSchema(schemaName).getViews());
            database.removeSchema(schemaName);
            Optional.of(schema).ifPresent(optional -> tobeRemovedTables.addAll(optional.getAllTableNames()));
            tobeRemovedSchemas.add(each.toLowerCase());
        }
        Collection rules = database.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (String each : tobeRemovedTables) {
            this.removeDataNode(rules, each, tobeRemovedSchemas);
        }
        return Optional.of(new DropSchemaEvent(database.getName(), schemaNames));
    }

    private Collection<String> getSchemaNames(DropSchemaStatement sqlStatement) {
        LinkedList<String> result = new LinkedList<String>();
        for (IdentifierValue each : sqlStatement.getSchemaNames()) {
            result.add(each.getValue().toLowerCase());
        }
        return result;
    }

    private void removeDataNode(Collection<MutableDataNodeRule> rules, String tobeRemovedTable, Collection<String> schemaNames) {
        for (MutableDataNodeRule each : rules) {
            each.remove(schemaNames, tobeRemovedTable);
        }
    }

    public String getType() {
        return DropSchemaStatement.class.getName();
    }
}

