/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.refresher.type.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.connection.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.instance.mode.ModeContextManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropIndexStatementHandler;

public final class DropIndexStatementSchemaRefresher
implements MetaDataRefresher<DropIndexStatement> {
    @Override
    public void refresh(ModeContextManager modeContextManager, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, DropIndexStatement sqlStatement, ConfigurationProperties props) {
        for (IndexSegment each : sqlStatement.getIndexes()) {
            String actualSchemaName = each.getOwner().map(optional -> optional.getIdentifier().getValue().toLowerCase()).orElse(schemaName);
            Optional<String> logicTableName = this.findLogicTableName(database, sqlStatement, Collections.singletonList(each));
            if (!logicTableName.isPresent()) continue;
            AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), actualSchemaName);
            ShardingSphereTable table = this.newShardingSphereTable(database.getSchema(actualSchemaName).getTable(logicTableName.get()));
            table.removeIndex(each.getIndexName().getIdentifier().getValue());
            alterSchemaMetaDataPOJO.getAlteredTables().add(table);
            modeContextManager.alterSchemaMetaData(alterSchemaMetaDataPOJO);
        }
    }

    private Optional<String> findLogicTableName(ShardingSphereDatabase database, DropIndexStatement sqlStatement, Collection<IndexSegment> indexSegments) {
        Optional simpleTableSegment = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)sqlStatement);
        if (simpleTableSegment.isPresent()) {
            return Optional.of(((SimpleTableSegment)simpleTableSegment.get()).getTableName().getIdentifier().getValue());
        }
        Collection tableNames = IndexMetaDataUtils.getTableNames((ShardingSphereDatabase)database, (DatabaseType)database.getProtocolType(), indexSegments);
        return tableNames.isEmpty() ? Optional.empty() : Optional.of(((QualifiedTable)tableNames.iterator().next()).getTableName());
    }

    private ShardingSphereTable newShardingSphereTable(ShardingSphereTable table) {
        ShardingSphereTable result = new ShardingSphereTable(table.getName(), table.getColumnValues(), table.getIndexValues(), table.getConstraintValues());
        result.getColumnNames().addAll(table.getColumnNames());
        result.getVisibleColumns().addAll(table.getVisibleColumns());
        result.getPrimaryKeyColumns().addAll(table.getPrimaryKeyColumns());
        return result;
    }

    @Override
    public Class<DropIndexStatement> getType() {
        return DropIndexStatement.class;
    }
}

